/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import uk.ac.warwick.util.cache.CacheEntry;
import uk.ac.warwick.util.cache.CacheEntryUpdateException;
import uk.ac.warwick.util.cache.CacheExpiryStrategy;
import uk.ac.warwick.util.cache.CacheListener;
import uk.ac.warwick.util.cache.CacheStatistics;
import uk.ac.warwick.util.cache.CacheStoreUnavailableException;

public interface Cache<K extends Serializable, V extends Serializable> {
    public V get(K var1) throws CacheEntryUpdateException;

    public Map<K, V> get(List<K> var1) throws CacheEntryUpdateException;

    public Result<V> getResult(K var1) throws CacheEntryUpdateException;

    public void put(CacheEntry<K, V> var1);

    public void addCacheListener(CacheListener<K, V> var1);

    public CacheStatistics getStatistics() throws CacheStoreUnavailableException;

    @Deprecated
    public void setMaxSize(int var1);

    @Deprecated
    public void setTimeout(int var1);

    @Deprecated
    public void setExpiryStrategy(CacheExpiryStrategy<K, V> var1);

    @Deprecated
    public void setAsynchronousUpdateEnabled(boolean var1);

    public String getName();

    public boolean remove(K var1);

    public boolean clear();

    public boolean contains(K var1);

    public void shutdown();

    public static class ResultImpl<V>
    implements Result<V> {
        private final V value;
        private final boolean updating;
        private final long lastUpdated;

        public ResultImpl(V value, boolean updating, long lastUpdated) {
            this.value = value;
            this.updating = updating;
            this.lastUpdated = lastUpdated;
        }

        @Override
        public long getLastUpdated() {
            return this.lastUpdated;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public boolean isUpdating() {
            return this.updating;
        }
    }

    public static interface Result<V> {
        public boolean isUpdating();

        public long getLastUpdated();

        public V getValue();
    }
}

