package uk.ac.warwick.util.web.useragent;

import java.util.HashMap;
import java.util.Map;

public class Targets {
  private Map<String, Version> targetVersions = new HashMap<>();

  public Targets chrome(int version) {
    return addTarget("chrome", version);
  }

  public Targets firefox(int version) {
    return addTarget("firefox", version);
  }

  public Targets safari(int major, int minor) {
    return addTarget("safari", major, minor);
  }

  public Targets edge(int version) {
    return addTarget("edge", version);
  }

  public Targets ie(int version) {
    return addTarget("ie", version);
  }

  public Targets samsung(int major, int minor) {
    return addTarget("samsung", major, minor);
  }

  private Targets addTarget(String name, int major) {
    return addTarget(name, major, 0);
  }

  private Targets addTarget(String name, int major, int minor) {
    targetVersions.put(name, new Version(major, minor));
    return this;
  }

  public Map<String, Version> getTargetVersions() {
    return targetVersions;
  }
}
