package uk.ac.warwick.util.mywarwick.model;

import javax.inject.Inject;
import javax.inject.Singleton;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

/** this implementation is for Spring applications **/
@Singleton
public class PropertiesConfiguration extends AbstractSpringConfiguration {

    private Properties applicationProperties;

    @Inject
    public PropertiesConfiguration(Properties applicationProperties) {
        super();
        this.applicationProperties = applicationProperties;
    }

    protected String getOrNull(String key) {
        return applicationProperties.getProperty(key);
    }

    @Override
    boolean keyExists(String key) {
        return applicationProperties.containsKey(key);
    }

}
