package uk.ac.warwick.util.files.impl;

import com.google.common.reflect.TypeToken;
import org.jclouds.Context;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.rest.Utils;

import java.io.Closeable;

public abstract class DelegatingBlobStoreContext implements BlobStoreContext {
  private final BlobStoreContext delegate;
    
  public DelegatingBlobStoreContext(BlobStoreContext delegate) {
    this.delegate = delegate;
  }

  public BlobRequestSigner getSigner() {
    return delegate.getSigner();
  }

  public BlobStore getBlobStore() {
    return delegate.getBlobStore();
  }

  public ConsistencyModel getConsistencyModel() {
    return delegate.getConsistencyModel();
  }

  public Utils utils() {
    return delegate.utils();
  }

  public void close() {
    delegate.close();
  }

  public TypeToken<?> getBackendType() {
    return delegate.getBackendType();
  }

  public <C extends Context> C unwrap(TypeToken<C> typeToken) throws IllegalArgumentException {
    return delegate.unwrap(typeToken);
  }

  public <C extends Context> C unwrap() throws ClassCastException {
    return delegate.unwrap();
  }

  public <A extends Closeable> A unwrapApi(Class<A> aClass) {
    return delegate.unwrapApi(aClass);
  }
}
