/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.spring.view.json;

import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import uk.ac.warwick.util.web.Uri;
import uk.ac.warwick.util.web.spring.view.json.JSONPRequestValidator;

public final class SameOriginHostJSONPRequestValidator
implements JSONPRequestValidator {
    private final String host;
    private boolean validByDefault = true;

    public SameOriginHostJSONPRequestValidator(String host) {
        this.host = host.indexOf("://") != -1 ? Uri.parse(host).getAuthority() : host;
    }

    @Override
    public boolean isAllow(HttpServletRequest request) {
        String referer = request.getHeader("Referer");
        if (StringUtils.hasText((String)referer)) {
            return Uri.parse(referer).getAuthority().equals(this.host);
        }
        return this.validByDefault;
    }

    public void setValidByDefault(boolean validByDefault) {
        this.validByDefault = validByDefault;
    }
}

