/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.spring.view.json;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.springframework.beans.factory.annotation.Configurable;
import uk.ac.warwick.util.web.spring.view.json.AbstractJSONView;
import uk.ac.warwick.util.web.spring.view.json.CompositeJSONPRequestValidator;
import uk.ac.warwick.util.web.spring.view.json.JSON;
import uk.ac.warwick.util.web.spring.view.json.JSONPRequestValidator;

@Configurable
public abstract class JSONArrayView
extends AbstractJSONView<JSONArray> {
    @Override
    public final JSON<JSONArray> renderToJSON(Map<String, Object> model, HttpServletRequest request, List<String> errors) throws Exception {
        return JSON.wrap(this.render(model, request, errors));
    }

    public abstract JSONArray render(Map<String, Object> var1, HttpServletRequest var2, List<String> var3) throws Exception;

    public static JSONArrayView combine(JSONArrayView ... views) {
        return new CombinedJSONArrayView(views);
    }

    public static JSONArrayView of(JSONArray array, String charEncoding, JSONPRequestValidator jsonPValidator) {
        return JSONArrayView.of(array, charEncoding, jsonPValidator, new String[0]);
    }

    public static JSONArrayView of(JSONArray array, String charEncoding, JSONPRequestValidator jsonPValidator, String ... error) {
        return JSONArrayView.of(array, charEncoding, jsonPValidator, Arrays.asList(error));
    }

    public static JSONArrayView of(JSONArray array, String charEncoding, JSONPRequestValidator jsonPValidator, Iterable<String> error) {
        return new PreconfiguredJSONArrayView(array, charEncoding, error, jsonPValidator);
    }

    public static JSONArrayView errors(String charEncoding, JSONPRequestValidator jsonPValidator, String ... error) {
        return JSONArrayView.errors(charEncoding, jsonPValidator, Arrays.asList(error));
    }

    public static JSONArrayView errors(String charEncoding, JSONPRequestValidator jsonPValidator, Iterable<String> error) {
        return JSONArrayView.of(new JSONArray(), charEncoding, jsonPValidator, error);
    }

    @Configurable
    public static class CombinedJSONArrayView
    extends JSONArrayView {
        private final Iterable<JSONArrayView> views;

        public CombinedJSONArrayView(JSONArrayView ... theViews) {
            this((Iterable<JSONArrayView>)ImmutableList.copyOf((Object[])theViews));
        }

        public CombinedJSONArrayView(Iterable<JSONArrayView> theViews) {
            this.views = theViews;
            this.setJsonpRequestValidator(new CompositeJSONPRequestValidator(Iterables.transform(theViews, (Function)new Function<JSONArrayView, JSONPRequestValidator>(){

                public JSONPRequestValidator apply(JSONArrayView view) {
                    return view.getJsonpRequestValidator();
                }
            })));
        }

        @Override
        public JSONArray render(Map<String, Object> model, HttpServletRequest request, List<String> errors) throws Exception {
            JSONArray combined = new JSONArray();
            for (JSONArrayView view : this.views) {
                JSONArray array = view.render(model, request, errors);
                for (int i = 0; i < array.length(); ++i) {
                    combined.put(array.get(i));
                }
            }
            return combined;
        }

        @Override
        public String getCharacterEncoding() {
            return this.views.iterator().next().getCharacterEncoding();
        }
    }

    @Configurable
    public static class PreconfiguredJSONArrayView
    extends JSONArrayView {
        private final JSONArray array;
        private final Iterable<String> errs;
        private final String characterEncoding;

        public PreconfiguredJSONArrayView(JSONArray arr, String charEncoding, Iterable<String> err, JSONPRequestValidator jsonPValidator) {
            this.array = arr;
            this.errs = err;
            this.characterEncoding = charEncoding;
            this.setJsonpRequestValidator(jsonPValidator);
        }

        @Override
        public JSONArray render(Map<String, Object> model, HttpServletRequest request, List<String> errors) throws Exception {
            for (String err : this.errs) {
                errors.add(err);
            }
            return this.array;
        }

        @Override
        public String getCharacterEncoding() {
            return this.characterEncoding;
        }
    }
}

