/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.filter.stack;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import uk.ac.warwick.util.collections.google.BasePredicate;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.web.filter.stack.CompositeFilter;
import uk.ac.warwick.util.web.filter.stack.FilterMappingParser;
import uk.ac.warwick.util.web.filter.stack.FilterMappingParserImpl;
import uk.ac.warwick.util.web.filter.stack.FilterStackSet;

public final class ConfigurableFilterStack
implements Filter,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurableFilterStack.class);
    private final ImmutableList<FilterStackSet> filterSets;
    private final LoadingCache<String, CompositeFilter> cache = Caffeine.newBuilder().maximumSize(10000L).build((CacheLoader)new FilterChainFactory());
    private FilterMappingParser parser;
    private boolean executeLifecycleEvents = true;

    public ConfigurableFilterStack(List<FilterStackSet> filters) {
        this.filterSets = ConfigurableFilterStack.merge(filters);
    }

    public static ImmutableList<FilterStackSet> merge(List<FilterStackSet> filters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet handledNames = Sets.newHashSet();
        ImmutableList copy = ImmutableList.copyOf(filters);
        for (FilterStackSet set : filters) {
            String name = set.getName();
            if (!StringUtils.hasText(name)) {
                builder.add((Object)set);
                continue;
            }
            if (!handledNames.add(name)) continue;
            builder.add((Object)FilterStackSet.merge(set, ConfigurableFilterStack.withName(name, set).filteredCopy((Iterable<FilterStackSet>)copy)));
        }
        return builder.build();
    }

    private static BasePredicate<FilterStackSet> withName(final String name, final FilterStackSet dupe) {
        return new BasePredicate<FilterStackSet>(){

            @Override
            public boolean apply(FilterStackSet set) {
                return set != dupe && name.equals(set.getName());
            }
        };
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String urlPath = request.getRequestURI().substring(request.getContextPath().length());
        CompositeFilter filter = (CompositeFilter)this.cache.get((Object)urlPath);
        filter.doFilter(req, res, chain);
    }

    public void init(FilterConfig cfg) throws ServletException {
        if (!this.executeLifecycleEvents) {
            return;
        }
        LOGGER.info("Calling init() on inner filters");
        int filterNumber = 0;
        HashSet<Filter> inittedFilters = new HashSet<Filter>();
        for (FilterStackSet set : this.filterSets) {
            for (Filter filter : set.getFilters()) {
                if (!inittedFilters.add(filter)) continue;
                String name = "internalFilter" + ++filterNumber;
                InnerFilterConfig config = new InnerFilterConfig(name, cfg.getServletContext());
                filter.init((FilterConfig)config);
            }
        }
        inittedFilters.clear();
    }

    public void destroy() {
        if (!this.executeLifecycleEvents) {
            return;
        }
        LOGGER.info("Calling destroy() on inner filters");
        HashSet<Filter> destroyedFilters = new HashSet<Filter>();
        for (FilterStackSet set : this.filterSets) {
            for (Filter filter : set.getFilters()) {
                if (!destroyedFilters.add(filter)) continue;
                filter.destroy();
            }
        }
        destroyedFilters.clear();
    }

    public boolean isExecuteLifecycleEvents() {
        return this.executeLifecycleEvents;
    }

    public void setExecuteLifecycleEvents(boolean executeLifecycleEvents) {
        this.executeLifecycleEvents = executeLifecycleEvents;
    }

    public void afterPropertiesSet() {
        if (this.parser == null) {
            this.parser = new FilterMappingParserImpl();
        }
        for (FilterStackSet set : this.filterSets) {
            set.setFilterMappingParser(this.parser);
        }
    }

    public List<FilterStackSet> getFilterSets() {
        return this.filterSets;
    }

    @VisibleForTesting
    LoadingCache<String, CompositeFilter> getCache() {
        return this.cache;
    }

    private final class FilterChainFactory
    implements CacheLoader<String, CompositeFilter> {
        private FilterChainFactory() {
        }

        @Nonnull
        public CompositeFilter load(@Nonnull String key) {
            ArrayList<Filter> filtersToRun = new ArrayList<Filter>();
            for (FilterStackSet set : ConfigurableFilterStack.this.filterSets) {
                if (!set.isMatch(key)) continue;
                filtersToRun.add(set.getCompositeFilter());
            }
            return new CompositeFilter(filtersToRun);
        }
    }

    public static final class InnerFilterConfig
    implements FilterConfig {
        private final String filterName;
        private final ServletContext servletContext;

        public InnerFilterConfig(String name, ServletContext context) {
            this.filterName = name;
            this.servletContext = context;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public String getInitParameter(String arg0) {
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            return new Vector().elements();
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }
    }
}

