/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.bind;

import java.beans.PropertyEditorSupport;
import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.util.StringUtils;

public final class UrlPropertyEditor
extends PropertyEditorSupport {
    @Override
    public String getAsText() {
        URL url = (URL)this.getValue();
        if (url == null) {
            return null;
        }
        return url.toString();
    }

    @Override
    public void setAsText(String value) throws IllegalArgumentException {
        if (!StringUtils.hasLength((String)value)) {
            this.setValue(null);
            return;
        }
        try {
            URL url = new URL(value);
            super.setValue(url);
        }
        catch (MalformedURLException e) {
            super.setValue(null);
            throw new IllegalArgumentException("Cannot convert " + value + " to URL", e);
        }
    }
}

