/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.termdates;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.termdates.AcademicYear;
import uk.ac.warwick.util.termdates.AcademicYearPeriod;
import uk.ac.warwick.util.termdates.ExtendedAcademicYear;
import uk.ac.warwick.util.termdates.Term;
import uk.ac.warwick.util.termdates.Vacation;

class TermDatesService {
    static final TermDatesService INSTANCE;
    private static final DateTimeFormatter DATE_FORMATTER;
    private final Map<Integer, AcademicYear> academicYears;
    private final Map<ExtendedAcademicYear.ExtendedEndStrategy, Map<Integer, ExtendedAcademicYear>> extendedAcademicYears;

    private TermDatesService() {
        try {
            ImmutableList.Builder termsBuilder = ImmutableList.builder();
            String source = StringUtils.copyToString(new InputStreamReader(Objects.requireNonNull(this.getClass().getResourceAsStream("/uk/ac/warwick/util/termdates/termdates.txt"))));
            StringTokenizer st = new StringTokenizer(source, "\n");
            while (st.hasMoreTokens()) {
                AcademicYearPeriod.PeriodType type;
                String line = st.nextToken().trim();
                String[] data = line.split(";");
                String firstDayString = data[0];
                String lastDayString = data[1];
                String termTypeString = data[2];
                LocalDate firstDay = LocalDate.parse(firstDayString, DATE_FORMATTER).with(DayOfWeek.MONDAY);
                LocalDate lastDay = LocalDate.parse(lastDayString, DATE_FORMATTER).with(DayOfWeek.SUNDAY);
                switch (termTypeString) {
                    case "a": {
                        type = AcademicYearPeriod.PeriodType.autumnTerm;
                        break;
                    }
                    case "sp": {
                        type = AcademicYearPeriod.PeriodType.springTerm;
                        break;
                    }
                    case "su": {
                        type = AcademicYearPeriod.PeriodType.summerTerm;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid term string");
                    }
                }
                termsBuilder.add((Object)Term.of(type, firstDay, lastDay));
            }
            ImmutableList terms = termsBuilder.build();
            TermDatesService.validate((List<Term>)terms);
            ImmutableMap.Builder academicYears = ImmutableMap.builder();
            Iterator itr = terms.iterator();
            while (itr.hasNext()) {
                Term autumnTerm = (Term)itr.next();
                Term springTerm = (Term)itr.next();
                Term summerTerm = (Term)itr.next();
                Vacation preTermVacation = Vacation.between(AcademicYearPeriod.PeriodType.preTermVacation, autumnTerm.getFirstDay().with(Month.AUGUST).withDayOfMonth(1), autumnTerm);
                Vacation winterVacation = Vacation.between(AcademicYearPeriod.PeriodType.christmasVacation, autumnTerm, springTerm);
                Vacation easterVacation = Vacation.between(AcademicYearPeriod.PeriodType.easterVacation, springTerm, summerTerm);
                Vacation summerVacation = Vacation.between(AcademicYearPeriod.PeriodType.summerVacation, summerTerm, summerTerm.getLastDay().with(Month.JULY).withDayOfMonth(31));
                AcademicYear year = AcademicYear.build(preTermVacation, autumnTerm, winterVacation, springTerm, easterVacation, summerTerm, summerVacation);
                academicYears.put((Object)year.getStartYear(), (Object)year);
            }
            this.academicYears = academicYears.build();
            ImmutableMap.Builder extendedAcademicYears = ImmutableMap.builder();
            for (ExtendedAcademicYear.ExtendedEndStrategy strategy : ExtendedAcademicYear.ExtendedEndStrategy.values()) {
                ImmutableMap.Builder extendedAcademicYearsForStrategy = ImmutableMap.builder();
                AcademicYear previousYear = null;
                for (AcademicYear year : this.academicYears.values().stream().sorted().collect(Collectors.toList())) {
                    if (previousYear != null) {
                        extendedAcademicYearsForStrategy.put((Object)previousYear.getStartYear(), (Object)ExtendedAcademicYear.wrap(previousYear, year, strategy));
                    }
                    previousYear = year;
                }
                extendedAcademicYears.put((Object)strategy, (Object)extendedAcademicYearsForStrategy.build());
            }
            this.extendedAcademicYears = Maps.immutableEnumMap((Map)extendedAcademicYears.build());
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't instantiate a TermDatesService", e);
        }
    }

    AcademicYear getAcademicYear(int startYear) {
        return this.academicYears.getOrDefault(startYear, AcademicYear.placeholder(startYear));
    }

    ExtendedAcademicYear getExtendedAcademicYear(int startYear, ExtendedAcademicYear.ExtendedEndStrategy strategy) {
        if (!this.extendedAcademicYears.containsKey((Object)strategy)) {
            throw new IllegalArgumentException("Unexpected ExtendedEndStrategy " + (Object)((Object)strategy));
        }
        return this.extendedAcademicYears.get((Object)strategy).getOrDefault(startYear, ExtendedAcademicYear.placeholder(startYear, strategy));
    }

    private static void validate(List<Term> terms) {
        TermDatesService.verify(!terms.isEmpty(), "Terms must be found");
        Iterator<Term> itr = terms.iterator();
        Term lastTerm = itr.next();
        TermDatesService.verify(lastTerm.getType() == AcademicYearPeriod.PeriodType.autumnTerm, "Must start with an Autumn term");
        while (itr.hasNext()) {
            Term nextTerm = itr.next();
            switch (lastTerm.getType()) {
                case autumnTerm: {
                    TermDatesService.verify(nextTerm.getType() == AcademicYearPeriod.PeriodType.springTerm, "Spring must follow Autumn");
                    break;
                }
                case springTerm: {
                    TermDatesService.verify(nextTerm.getType() == AcademicYearPeriod.PeriodType.summerTerm, "Summer must follow Spring");
                    break;
                }
                case summerTerm: {
                    TermDatesService.verify(nextTerm.getType() == AcademicYearPeriod.PeriodType.autumnTerm, "Autumn must follow Summer");
                }
            }
            TermDatesService.verify(nextTerm.isAfter(lastTerm), "Must follow previous term");
            lastTerm = nextTerm;
        }
        TermDatesService.verify(lastTerm.getType() == AcademicYearPeriod.PeriodType.summerTerm, "Must end with a Summer term");
    }

    private static void verify(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    static {
        DATE_FORMATTER = DateTimeFormatter.ofPattern("ddMMyy");
        INSTANCE = new TermDatesService();
    }
}

