/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick.model;

import java.io.IOException;
import java.time.Duration;
import java.util.Properties;
import java.util.Set;
import uk.ac.warwick.util.mywarwick.model.Instance;
import uk.ac.warwick.util.mywarwick.model.PropertiesConfiguration;

public interface Configuration {
    public Set<Instance> getInstances();

    public int getHttpMaxConn();

    public int getHttpMaxConnPerRoute();

    public String getQuartzHealthcheckName();

    public long getQuartzHealthcheckQueueSizeWarningThreshold();

    public long getQuartzHealthcheckQueueSizeCriticalThreshold();

    public Duration getQuartzHealthcheckDelayWarningThreshold();

    public Duration getQuartzHealthcheckDelayCriticalThreshold();

    default public void validate() throws IllegalArgumentException {
        if (this.getInstances() == null) {
            throw new IllegalArgumentException("mywarwick Configuration getInstances() returns null");
        }
        if (this.getInstances().size() == 0) {
            throw new IllegalArgumentException("mywarwick Configuration getInstances() contains 0 instances, please check your configuration(Spring property file, or Play config file)");
        }
    }

    public static Properties loadDefaults() {
        Properties properties = new Properties();
        try {
            properties.load(PropertiesConfiguration.class.getResourceAsStream("mywarwick-defaults.properties"));
            return properties;
        }
        catch (IOException e) {
            throw new IllegalStateException("defaults.properties missing");
        }
    }
}

