/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import java.sql.Date;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.core.DateTimeUtils;
import uk.ac.warwick.util.mywarwick.MyWarwickService;
import uk.ac.warwick.util.mywarwick.model.Configuration;
import uk.ac.warwick.util.mywarwick.model.Instance;
import uk.ac.warwick.util.mywarwick.model.response.Response;

public class SendMyWarwickActivityJob
implements Job {
    public static final JobKey JOB_KEY = new JobKey("SendActivityJob", "warwickutils-mywarwick");
    public static final String INSTANCE_BASE_URL_DATA_KEY = "instanceBaseUrl";
    public static final String IS_NOTIFICATION_JOB_DATA_KEY = "isNotification";
    public static final String IS_TRANSIENT_JOB_DATA_KEY = "isTransient";
    public static final String REQUEST_BODY_JOB_DATA_KEY = "requestBody";
    public static final String CREATED_DATETIME_ISO8601_DATA_KEY = "createdDateTimeISO8601";
    private static final Logger LOGGER = LoggerFactory.getLogger(SendMyWarwickActivityJob.class);
    private static final Duration RESCHEDULE_DELAY = Duration.ofSeconds(30L);
    private final MyWarwickService myWarwickService;
    private final Scheduler scheduler;
    private final Set<Instance> instances;

    @Inject
    public SendMyWarwickActivityJob(MyWarwickService myWarwickService, Scheduler scheduler, Configuration configuration) {
        this.myWarwickService = myWarwickService;
        this.scheduler = scheduler;
        this.instances = configuration.getInstances();
    }

    private void reschedule(JobExecutionContext context) throws JobExecutionException {
        try {
            this.scheduler.rescheduleJob(context.getTrigger().getKey(), TriggerBuilder.newTrigger().withIdentity(context.getTrigger().getKey()).startAt(Date.from(Instant.now(DateTimeUtils.CLOCK_IMPLEMENTATION).plusSeconds(RESCHEDULE_DELAY.getSeconds()))).usingJobData(context.getTrigger().getJobDataMap()).build());
        }
        catch (SchedulerException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        block13: {
            JobDataMap jobDataMap = context.getMergedJobDataMap();
            String instanceBaseUrl = jobDataMap.getString(INSTANCE_BASE_URL_DATA_KEY);
            if (instanceBaseUrl == null) {
                for (Instance instance : this.instances) {
                    try {
                        JobDataMap data = new JobDataMap((Map)context.getTrigger().getJobDataMap());
                        data.put(INSTANCE_BASE_URL_DATA_KEY, instance.getBaseUrl());
                        this.scheduler.scheduleJob(TriggerBuilder.newTrigger().forJob(JOB_KEY).usingJobData(data).build());
                    }
                    catch (SchedulerException e2) {
                        throw new JobExecutionException((Throwable)e2);
                    }
                }
                return;
            }
            Optional<Instance> requestedInstance = this.instances.stream().filter(i -> i.getBaseUrl().equals(instanceBaseUrl)).findFirst();
            if (requestedInstance.isPresent()) {
                Instance instance = requestedInstance.get();
                String requestBody = jobDataMap.getString(REQUEST_BODY_JOB_DATA_KEY);
                boolean isNotification = jobDataMap.getBooleanValueFromString(IS_NOTIFICATION_JOB_DATA_KEY);
                boolean isTransient = jobDataMap.getBooleanValueFromString(IS_TRANSIENT_JOB_DATA_KEY);
                try {
                    Response response = this.myWarwickService.sendSingleInstance(instance, requestBody, isNotification, isTransient, 3).join();
                    if (Boolean.TRUE.equals(response.getSuccess())) {
                        LOGGER.trace("Sent My Warwick activity " + requestBody);
                        break block13;
                    }
                    if (Boolean.FALSE.equals(response.getSuccess())) {
                        String errorMessage = response.getErrors().stream().map(e -> {
                            if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                                return e.getMessage();
                            }
                            return e.getId();
                        }).collect(Collectors.joining(", "));
                        if (response.getErrors().stream().anyMatch(e -> e.getId().equals("no-permission"))) {
                            this.doLog(instance, String.format("Missing permission to send My Warwick activity (%S): %s - retrying in %ss", response.getStatus(), errorMessage, RESCHEDULE_DELAY.getSeconds()));
                            this.reschedule(context);
                        } else {
                            this.doLog(instance, String.format("Validation error sending My Warwick activity (%s): %s - cancelling", response.getStatus(), errorMessage));
                        }
                        break block13;
                    }
                    this.doLog(instance, String.format("Unexpected response from My Warwick (%s) - retrying in %ss", response.getStatus(), RESCHEDULE_DELAY.getSeconds()));
                    this.reschedule(context);
                }
                catch (CancellationException e3) {
                    this.doLog(instance, String.format("CompletableFuture cancelled while sending My Warwick activity, retrying in %ss", RESCHEDULE_DELAY.getSeconds()), e3);
                    this.reschedule(context);
                }
                catch (CompletionException e4) {
                    this.doLog(instance, String.format("Exception sending activity, retrying in %ss", RESCHEDULE_DELAY.getSeconds()), e4);
                    this.reschedule(context);
                }
            } else {
                LOGGER.error("Error sending My Warwick activity, instance " + instanceBaseUrl + " couldn't be found, cancelling");
            }
        }
    }

    private void doLog(Instance instance, String message) {
        if (instance.isLogErrors()) {
            LOGGER.error(String.format("%s: %s", instance.getBaseUrl(), message));
        } else {
            LOGGER.warn(String.format("%s: %s", instance.getBaseUrl(), message));
        }
    }

    private void doLog(Instance instance, String message, Throwable e) {
        if (instance.isLogErrors()) {
            LOGGER.error(String.format("%s: %s", instance.getBaseUrl(), message), e);
        } else {
            LOGGER.warn(String.format("%s: %s", instance.getBaseUrl(), message), e);
        }
    }
}

