/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import javax.validation.constraints.NotNull;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.slf4j.Logger;
import uk.ac.warwick.util.mywarwick.HttpClient;

public class RetryingHttpResponseCallback
implements FutureCallback<HttpResponse> {
    private final HttpClient httpclient;
    private final FutureCallback<HttpResponse> callback;
    private final Logger logger;
    private final int maxAttempts;
    private HttpRequestBase request;
    private int numberOfAttempts = 1;

    RetryingHttpResponseCallback(@NotNull HttpClient httpclient, @NotNull HttpRequestBase request, @NotNull FutureCallback<HttpResponse> callback, @NotNull Logger logger, int maxAttempts) {
        this.httpclient = httpclient;
        this.request = request;
        this.callback = callback;
        this.maxAttempts = maxAttempts;
        this.logger = logger;
    }

    public void completed(HttpResponse httpResponse) {
        this.callback.completed((Object)httpResponse);
    }

    public void failed(Exception e) {
        try {
            if (this.numberOfAttempts < this.maxAttempts) {
                this.logger.warn("Request to mywarwick API has failed:\nURI: " + this.request.getURI() + "\nattempt: " + this.numberOfAttempts + "\nmax attempts: " + this.maxAttempts + "\nerror message:" + e.getMessage(), (Throwable)e);
                RequestConfig requestConfig = this.httpclient.getRequestConfig();
                this.request.setConfig(RequestConfig.copy((RequestConfig)requestConfig).setConnectTimeout(requestConfig.getConnectTimeout() * Double.valueOf(Math.pow(2.0, this.numberOfAttempts)).intValue()).setSocketTimeout(requestConfig.getSocketTimeout() * Double.valueOf(Math.pow(2.0, this.numberOfAttempts)).intValue()).build());
                ++this.numberOfAttempts;
                this.httpclient.execute((HttpUriRequest)this.request, this);
            } else {
                this.callback.failed(e);
            }
        }
        catch (Exception innerException) {
            this.callback.failed(e);
        }
    }

    public void cancelled() {
        this.callback.cancelled();
    }
}

