/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.validation.constraints.NotNull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import uk.ac.warwick.util.mywarwick.model.Instance;

public class HasRegistrationHttpResponseCallback
implements FutureCallback<HttpResponse> {
    private final String reqPath;
    private final Instance myWarwickInstance;
    private final Logger logger;
    private final CompletableFuture<Boolean> completableFuture;

    HasRegistrationHttpResponseCallback(@NotNull String reqPath, @NotNull Instance myWarwickInstance, @NotNull Logger logger, @NotNull CompletableFuture<Boolean> completableFuture) {
        this.reqPath = reqPath;
        this.myWarwickInstance = myWarwickInstance;
        this.logger = logger;
        this.completableFuture = completableFuture;
    }

    public void completed(HttpResponse httpResponse) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Request completed");
        }
        try {
            ObjectNode node = (ObjectNode)new ObjectMapper().readValue(EntityUtils.toString((HttpEntity)httpResponse.getEntity()), ObjectNode.class);
            if (node.has("data")) {
                this.completeFuture(node.get("data").asBoolean());
                return;
            }
            this.completeFuture(false);
        }
        catch (IOException e) {
            this.logError("An IOException was thrown communicating with mywarwick:\n" + e.getMessage() + "\nbaseUrl: " + this.myWarwickInstance.getBaseUrl());
            this.completeFuture(false);
        }
    }

    public void failed(Exception e) {
        this.completeFuture(false);
    }

    public void cancelled() {
        this.completeFuture(false);
    }

    private void logError(String message) {
        if (this.myWarwickInstance.isLogErrors()) {
            this.logger.error(message);
        } else {
            this.logger.warn(message);
        }
    }

    private void logError(String message, Exception e) {
        if (this.myWarwickInstance.isLogErrors()) {
            this.logger.error(message, (Throwable)e);
        } else {
            this.logger.warn(message, (Throwable)e);
        }
    }

    private void completeFuture(boolean response) {
        this.completableFuture.complete(response);
    }
}

