/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mail;

import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;
import org.springframework.mail.MailPreparationException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;
import uk.ac.warwick.util.concurrency.TaskExecutionService;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.mail.MimeMessageUtilities;
import uk.ac.warwick.util.mail.WarwickMailSender;

public final class AsynchronousWarwickMailSender
implements WarwickMailSender {
    private static final String DEFAULT_SENDER = "no-reply@warwick.ac.uk";
    private static final Logger LOGGER = LoggerFactory.getLogger(AsynchronousWarwickMailSender.class);
    private final TaskExecutionService executionService;
    private final JavaMailSender mailSender;
    private String sender = "no-reply@warwick.ac.uk";

    public AsynchronousWarwickMailSender(TaskExecutionService service, JavaMailSender sender) {
        this.executionService = service;
        this.mailSender = sender;
    }

    @Override
    public MimeMessage createMimeMessage() {
        return this.mailSender.createMimeMessage();
    }

    @Override
    public Future<Boolean> send(MimeMessage message, boolean logBody) throws MailException {
        return this.sendAndReturnFuture(message, logBody);
    }

    @Override
    public Future<Boolean> send(SimpleMailMessage message) throws MailException {
        return this.sendAndReturnFuture(message);
    }

    @Override
    public Future<Boolean> send(MimeMessagePreparator preparator, boolean logBody) throws MailException {
        MimeMessage message = this.createMimeMessage();
        try {
            preparator.prepare(message);
        }
        catch (Exception ex) {
            throw new MailPreparationException((Throwable)ex);
        }
        return this.sendAndReturnFuture(message, logBody);
    }

    private Future<Boolean> sendAndReturnFuture(MimeMessage message, boolean logBody) throws MailException {
        try {
            this.validateRecipients(message.getAllRecipients());
            this.validateRecipients(message.getFrom());
            if (StringUtils.hasText(this.sender)) {
                message.setSender((Address)new InternetAddress(this.sender));
            }
        }
        catch (MessagingException e) {
            throw new MailParseException((Throwable)e);
        }
        return this.executionService.submit(new MimeMailSenderTask(this.mailSender, message, logBody));
    }

    private Future<Boolean> sendAndReturnFuture(SimpleMailMessage message) throws MailException {
        try {
            this.validateAddress(message.getFrom());
            this.validateAddresses(message.getTo());
            this.validateAddresses(message.getCc());
            this.validateAddresses(message.getBcc());
        }
        catch (MessagingException e) {
            throw new MailParseException((Throwable)e);
        }
        return this.executionService.submit(new SimpleMailSenderTask(this.mailSender, message));
    }

    private void validateRecipients(Address[] recipients) throws AddressException {
        if (recipients != null) {
            for (Address address : recipients) {
                this.validateAddress(address.toString());
            }
        }
    }

    private void validateAddress(String address) throws AddressException {
        if (StringUtils.hasText(address)) {
            InternetAddress ia = new InternetAddress(address);
            ia.validate();
        }
    }

    private void validateAddresses(String[] addresses) throws AddressException {
        if (addresses != null) {
            for (String address : addresses) {
                this.validateAddress(address);
            }
        }
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    private static class SimpleMailSenderTask
    implements Callable<Boolean> {
        private final JavaMailSender sender;
        private final SimpleMailMessage message;

        public SimpleMailSenderTask(JavaMailSender javaMailSender, SimpleMailMessage theMessage) {
            this.sender = javaMailSender;
            this.message = theMessage;
        }

        @Override
        public Boolean call() {
            String logRef = UUID.randomUUID().toString();
            String logRefText = String.format("(logId=%s)", logRef);
            LOGGER.info(String.format("Trying to send mail %s %s", this.message, logRefText));
            try {
                this.sender.send(this.message);
                LOGGER.info(String.format("Message sent successfully %s", logRefText));
                return true;
            }
            catch (Exception e) {
                LOGGER.error(String.format("Error sending mail %s", logRefText), (Throwable)e);
                return false;
            }
        }
    }

    private static class MimeMailSenderTask
    implements Callable<Boolean> {
        private final JavaMailSender sender;
        private final MimeMessage message;
        private final boolean logBody;

        public MimeMailSenderTask(JavaMailSender javaMailSender, MimeMessage theMessage, boolean logBody) {
            this.sender = javaMailSender;
            this.message = theMessage;
            this.logBody = logBody;
        }

        public MimeMailSenderTask(JavaMailSender javaMailSender, MimeMessage theMessage) {
            this(javaMailSender, theMessage, false);
        }

        @Override
        public Boolean call() {
            String logRef = UUID.randomUUID().toString();
            String logRefText = String.format("(logref=%s)", logRef);
            try {
                LOGGER.info(String.format("Trying to send mail %s %s", MimeMessageUtilities.mimeMessageToString(this.message, this.logBody), logRefText));
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Exception toString() for message: %s %s", this.message, logRefText));
            }
            try {
                this.sender.send(this.message);
                LOGGER.info(String.format("Message sent successfully %s", logRefText));
                return true;
            }
            catch (Exception e) {
                LOGGER.error(String.format("Error sending mail %s", logRefText), (Throwable)e);
                return false;
            }
        }
    }
}

