/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.httpclient.httpclient4;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import uk.ac.warwick.util.collections.Pair;
import uk.ac.warwick.util.httpclient.httpclient4.HttpClientFactory;
import uk.ac.warwick.util.httpclient.httpclient4.HttpRequestDecorator;
import uk.ac.warwick.util.web.Uri;

public interface HttpMethodExecutor
extends Serializable {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    public static final int DEFAULT_RETRIEVAL_TIMEOUT = 5000;
    public static final ResponseHandler<byte[]> RESPONSE_AS_BYTES = new ResponseHandler<byte[]>(){

        public byte[] handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                return EntityUtils.toByteArray((HttpEntity)entity);
            }
            return null;
        }
    };
    public static final ResponseHandler<String> RESPONSE_AS_STRING = new ResponseHandler<String>(){

        public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                return EntityUtils.toString((HttpEntity)entity);
            }
            return null;
        }
    };
    public static final ResponseHandler<Void> IGNORE_RESPONSE = new ResponseHandler<Void>(){

        public Void handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            return null;
        }
    };

    public <T> Pair<Integer, T> execute(ResponseHandler<T> var1) throws IOException;

    public int execute(StreamCallback var1) throws IOException;

    public Date getLastModifiedDate();

    public String getUrl();

    public Uri getUri();

    public String getHeader(String var1);

    public String getRedirectUrl();

    public HttpResponse getResponse();

    public HttpContext getContext();

    public void setUrl(String var1);

    public void setUrl(Uri var1);

    public void setSubstituteWarwickTags(boolean var1);

    public void setFollowRedirects(boolean var1);

    public void setSSOCookie(boolean var1);

    public void setConnectionTimeout(int var1);

    public void setRetrievalTimeout(int var1);

    public void setHttpClientFactoryStrategyAsString(String var1);

    public void setMultipartBody(List<Pair<String, ? extends ContentBody>> var1);

    public List<Pair<String, ? extends ContentBody>> getMultipartBody();

    public void setPostBody(List<? extends NameValuePair> var1);

    public List<? extends NameValuePair> getPostBody();

    public void setJsonBody(JSONObject var1);

    public JSONObject getJsonBody();

    public void addHeader(String var1, String var2);

    public void addHeader(Header var1);

    public void setHttpClientFactory(HttpClientFactory var1);

    public void setHttp10Only(boolean var1);

    public void setUseExpectContinueHeader(boolean var1);

    public void setHttpRequestDecorator(HttpRequestDecorator var1);

    public static enum Method {
        get(false),
        head(false),
        patch(true),
        put(true),
        post(true);

        private final boolean hasBody;

        private Method(boolean hasBody) {
            this.hasBody = hasBody;
        }

        boolean hasBody() {
            return this.hasBody;
        }
    }

    public static interface StreamCallback {
        public void doWithStream(InputStream var1);
    }
}

