/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.internal.MultipartUploadSlicingAlgorithm;
import org.jclouds.http.HttpResponseException;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.io.internal.BasePayloadSlicer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import uk.ac.warwick.util.concurrency.CountingCompletionService;
import uk.ac.warwick.util.concurrency.TaskExecutionCompletionService;
import uk.ac.warwick.util.concurrency.TaskExecutionService;
import uk.ac.warwick.util.files.FileReference;
import uk.ac.warwick.util.files.FileReferenceCreationStrategy;
import uk.ac.warwick.util.files.HashFileReference;
import uk.ac.warwick.util.files.LocalFileReference;
import uk.ac.warwick.util.files.Storeable;
import uk.ac.warwick.util.files.hash.FileHashResolver;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.impl.AbstractFileStore;
import uk.ac.warwick.util.files.impl.BlobBackedLocalFileReference;

public final class BlobStoreFileStore
extends AbstractFileStore
implements InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlobStoreFileStore.class);
    private final BlobStore blobStore;
    private final String containerPrefix;
    private final PayloadSlicer payloadSlicer = new BasePayloadSlicer();
    private final TaskExecutionService executionService = new TaskExecutionService(Executors.newCachedThreadPool());

    public BlobStoreFileStore(Map<String, FileHashResolver> resolvers, FileReferenceCreationStrategy strategy, BlobStoreContext context, String containerPrefix) {
        super(resolvers, strategy);
        this.blobStore = context.getBlobStore();
        this.containerPrefix = containerPrefix;
    }

    @Override
    protected HashFileReference doStore(ByteSource in, HashString hash, HashFileReference target) throws IOException {
        return this.doStore(in, hash.getHash(), this.containerPrefix + (hash.isDefaultStore() ? "default" : hash.getStoreName()), target);
    }

    <T extends FileReference> T doStore(ByteSource in, String key, String container, T target) throws IOException {
        if (target.isFileBacked()) {
            throw new UnsupportedOperationException("Storage to file backed data not implemented");
        }
        long size = in.size();
        Blob blob = this.blobStore.blobBuilder(key).payload(in).contentLength(size).build();
        this.statistics.time(() -> {
            try {
                this.doPut(container, blob, size);
            }
            catch (HttpResponseException e) {
                LOGGER.warn("PUT: HttpResponseException encountered; might be a 401, so checking for fresh tokens and retrying...");
                this.blobStore.blobMetadata(container, key);
                this.doPut(container, blob, size);
            }
        }, this.statistics::referenceWritten);
        return target;
    }

    private void doPut(String container, Blob blob, long size) throws IOException {
        if (size > 0x3200000L) {
            long partSize = new MultipartUploadSlicingAlgorithm(this.blobStore.getMinimumMultipartPartSize(), this.blobStore.getMaximumMultipartPartSize(), this.blobStore.getMaximumNumberOfParts()).calculateChunkSize(size);
            MultipartUpload multipartUpload = this.blobStore.initiateMultipartUpload(container, (BlobMetadata)blob.getMetadata(), (PutOptions)PutOptions.NONE);
            int i = 1;
            CountingCompletionService completionService = this.executionService.newCompletionService();
            for (Payload payload : this.payloadSlicer.slice(blob.getPayload(), partSize)) {
                int index = i++;
                ((TaskExecutionCompletionService)completionService).submit(() -> this.blobStore.uploadMultipartPart(multipartUpload, index, payload));
            }
            try {
                List parts = ((TaskExecutionCompletionService)completionService).waitForCompletion(true).stream().sorted(Comparator.comparing(MultipartPart::partNumber)).collect(Collectors.toList());
                this.blobStore.completeMultipartUpload(multipartUpload, parts);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        } else {
            this.blobStore.putBlob(container, blob, (PutOptions)PutOptions.NONE);
        }
    }

    @Override
    public LocalFileReference getForPath(Storeable.StorageStrategy storageStrategy, String path) {
        String container = this.containerPrefix + storageStrategy.getRootPath();
        return new BlobBackedLocalFileReference(this, this.blobStore, container, path, storageStrategy);
    }

    @Override
    public Stream<String> list(Storeable.StorageStrategy storageStrategy, String basePath) {
        return this.statistics.timeSafe(() -> {
            String containerName = this.containerPrefix + storageStrategy.getRootPath();
            PageSet firstResults = this.blobStore.list(containerName, ListContainerOptions.Builder.prefix((String)basePath).recursive());
            return this.listKeys(containerName, basePath, firstResults.getNextMarker(), firstResults.stream().map(StorageMetadata::getName));
        }, this.statistics::traversed);
    }

    private Stream<String> listKeys(String containerName, String prefix, String nextMarker, Stream<String> accumulator) {
        if (nextMarker == null) {
            return accumulator;
        }
        PageSet nextResults = this.blobStore.list(containerName, ListContainerOptions.Builder.prefix((String)prefix).afterMarker(nextMarker).recursive());
        return Stream.concat(accumulator, this.listKeys(containerName, prefix, nextResults.getNextMarker(), nextResults.stream().map(StorageMetadata::getName)));
    }

    @Override
    public LocalFileReference storeLocalReference(Storeable storeable, ByteSource in) throws IOException {
        LocalFileReference ref = this.getForPath(storeable.getStrategy(), storeable.getPath());
        return this.doStore(in, storeable.getPath(), this.containerPrefix + storeable.getStrategy().getRootPath(), ref);
    }

    @Override
    public LocalFileReference copy(LocalFileReference ref, Storeable targetStoreable) throws IOException {
        return ref.copyTo(targetStoreable.getPath());
    }

    @Override
    public LocalFileReference rename(LocalFileReference ref, Storeable targetStoreable) throws IOException {
        return ref.renameTo(targetStoreable.getPath());
    }

    public void destroy() {
        this.executionService.shutdown();
    }
}

