/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.csv;

public abstract class DuplicateResolver<T> {
    public abstract T getAlternate(T var1);

    public static DuplicateResolver<String> incrementingNumber() {
        return new IncrementingNumberDuplicateResolver();
    }

    static class IncrementingNumberDuplicateResolver
    extends DuplicateResolver<String> {
        private int number = 2;

        IncrementingNumberDuplicateResolver() {
        }

        @Override
        public String getAlternate(String existingName) {
            String result = existingName + " " + this.number;
            ++this.number;
            return result;
        }
    }
}

