/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.spring;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.aop.ThrowsAdvice;
import uk.ac.warwick.util.core.ThreadSafeStopWatch;

public final class PerformanceLoggingAdvice
implements MethodBeforeAdvice,
AfterReturningAdvice,
ThrowsAdvice,
Serializable {
    private static final long serialVersionUID = -1727631392636075100L;

    public void before(Method method, Object[] args, Object target) throws Throwable {
        String name = target.getClass().getName().substring(target.getClass().getName().lastIndexOf(".") + 1) + "." + method.getName();
        name = name + "(";
        boolean first = true;
        if (args != null) {
            for (Object arg : args) {
                if (first) {
                    first = false;
                } else {
                    name = name + ", ";
                }
                name = arg == null || arg.toString() == null ? name + "null" : name + arg.toString();
            }
        }
        name = name + ")";
        ThreadSafeStopWatch.start(name);
    }

    public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
        ThreadSafeStopWatch.stop();
    }

    public void afterThrowing(Exception exception) {
        ThreadSafeStopWatch.stop();
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
    }
}

