/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.spring;

import java.util.Map;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import uk.ac.warwick.util.core.NumberUtils;

public abstract class ParameterUtils {
    private static final IntParser INT_PARSER = new IntParser();
    private static final LongParser LONG_PARSER = new LongParser();
    private static final FloatParser FLOAT_PARSER = new FloatParser();
    private static final DoubleParser DOUBLE_PARSER = new DoubleParser();
    private static final BooleanParser BOOLEAN_PARSER = new BooleanParser();
    private static final StringParser STRING_PARSER = new StringParser();

    public static Integer getIntParameter(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        if (request.get(name) == null) {
            return null;
        }
        return new Integer(ParameterUtils.getRequiredIntParameter(request, name));
    }

    public static int getIntParameter(Map<String, String[]> request, String name, int defaultVal) {
        if (request.get(name) == null) {
            return defaultVal;
        }
        try {
            return ParameterUtils.getRequiredIntParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static int[] getIntParameters(Map<String, String[]> request, String name) {
        try {
            return ParameterUtils.getRequiredIntParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new int[0];
        }
    }

    public static int getRequiredIntParameter(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        return INT_PARSER.parseInt(name, ParameterUtils.getFirst(request, name));
    }

    private static String getFirst(Map<String, String[]> request, String name) {
        String[] values = request.get(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public static int[] getRequiredIntParameters(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        return INT_PARSER.parseInts(name, request.get(name));
    }

    public static Long getLongParameter(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        if (request.get(name) == null) {
            return null;
        }
        return new Long(ParameterUtils.getRequiredLongParameter(request, name));
    }

    public static long getLongParameter(Map<String, String[]> request, String name, long defaultVal) {
        if (request.get(name) == null) {
            return defaultVal;
        }
        try {
            return ParameterUtils.getRequiredLongParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static long[] getLongParameters(Map<String, String[]> request, String name) {
        try {
            return ParameterUtils.getRequiredLongParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new long[0];
        }
    }

    public static long getRequiredLongParameter(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        return LONG_PARSER.parseLong(name, ParameterUtils.getFirst(request, name));
    }

    public static long[] getRequiredLongParameters(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        return LONG_PARSER.parseLongs(name, request.get(name));
    }

    public static Float getFloatParameter(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        if (request.get(name) == null) {
            return null;
        }
        return new Float(ParameterUtils.getRequiredFloatParameter(request, name));
    }

    public static float getFloatParameter(Map<String, String[]> request, String name, float defaultVal) {
        if (request.get(name) == null) {
            return defaultVal;
        }
        try {
            return ParameterUtils.getRequiredFloatParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static float[] getFloatParameters(Map<String, String[]> request, String name) {
        try {
            return ParameterUtils.getRequiredFloatParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new float[0];
        }
    }

    public static float getRequiredFloatParameter(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        return FLOAT_PARSER.parseFloat(name, ParameterUtils.getFirst(request, name));
    }

    public static float[] getRequiredFloatParameters(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        return FLOAT_PARSER.parseFloats(name, request.get(name));
    }

    public static Double getDoubleParameter(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        if (request.get(name) == null) {
            return null;
        }
        return new Double(ParameterUtils.getRequiredDoubleParameter(request, name));
    }

    public static double getDoubleParameter(Map<String, String[]> request, String name, double defaultVal) {
        if (request.get(name) == null) {
            return defaultVal;
        }
        try {
            return ParameterUtils.getRequiredDoubleParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static double[] getDoubleParameters(Map<String, String[]> request, String name) {
        try {
            return ParameterUtils.getRequiredDoubleParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new double[0];
        }
    }

    public static double getRequiredDoubleParameter(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        return DOUBLE_PARSER.parseDouble(name, ParameterUtils.getFirst(request, name));
    }

    public static double[] getRequiredDoubleParameters(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        return DOUBLE_PARSER.parseDoubles(name, request.get(name));
    }

    public static Boolean getBooleanParameter(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        if (request.get(name) == null) {
            return null;
        }
        return ParameterUtils.getRequiredBooleanParameter(request, name) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean getBooleanParameter(Map<String, String[]> request, String name, boolean defaultVal) {
        if (request.get(name) == null) {
            return defaultVal;
        }
        try {
            return ParameterUtils.getRequiredBooleanParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static boolean[] getBooleanParameters(Map<String, String[]> request, String name) {
        try {
            return ParameterUtils.getRequiredBooleanParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new boolean[0];
        }
    }

    public static boolean getRequiredBooleanParameter(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        return BOOLEAN_PARSER.parseBoolean(name, ParameterUtils.getFirst(request, name));
    }

    public static boolean[] getRequiredBooleanParameters(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        return BOOLEAN_PARSER.parseBooleans(name, request.get(name));
    }

    public static String getStringParameter(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        if (request.get(name) == null) {
            return null;
        }
        return ParameterUtils.getRequiredStringParameter(request, name);
    }

    public static String getStringParameter(Map<String, String[]> request, String name, String defaultVal) {
        String val = ParameterUtils.getFirst(request, name);
        return val != null ? val : defaultVal;
    }

    public static String[] getStringParameters(Map<String, String[]> request, String name) {
        try {
            return ParameterUtils.getRequiredStringParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new String[0];
        }
    }

    public static String getRequiredStringParameter(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        return STRING_PARSER.validateRequiredString(name, ParameterUtils.getFirst(request, name));
    }

    public static String[] getRequiredStringParameters(Map<String, String[]> request, String name) throws ServletRequestBindingException {
        return STRING_PARSER.validateRequiredStrings(name, request.get(name));
    }

    private static class StringParser
    extends ParameterParser {
        private StringParser() {
        }

        @Override
        protected String getType() {
            return "string";
        }

        @Override
        protected Object doParse(String parameter) throws NumberFormatException {
            return parameter;
        }

        public String validateRequiredString(String name, String value) throws ServletRequestBindingException {
            this.validateRequiredParameter(name, value);
            return value;
        }

        public String[] validateRequiredStrings(String name, String[] values) throws ServletRequestBindingException {
            this.validateRequiredParameter(name, values);
            for (int i = 0; i < values.length; ++i) {
                this.validateRequiredParameter(name, values[i]);
            }
            return values;
        }
    }

    private static class BooleanParser
    extends ParameterParser {
        private BooleanParser() {
        }

        @Override
        protected String getType() {
            return "boolean";
        }

        @Override
        protected Object doParse(String parameter) throws NumberFormatException {
            return parameter.equalsIgnoreCase("true") || parameter.equalsIgnoreCase("on") || parameter.equalsIgnoreCase("yes") || parameter.equals("1") ? Boolean.TRUE : Boolean.FALSE;
        }

        public boolean parseBoolean(String name, String parameter) throws ServletRequestBindingException {
            return (Boolean)this.parse(name, parameter);
        }

        public boolean[] parseBooleans(String name, String[] values) throws ServletRequestBindingException {
            this.validateRequiredParameter(name, values);
            boolean[] parameters = new boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseBoolean(name, values[i]);
            }
            return parameters;
        }
    }

    private static class DoubleParser
    extends ParameterParser {
        private DoubleParser() {
        }

        @Override
        protected String getType() {
            return "double";
        }

        @Override
        protected Object doParse(String parameter) throws NumberFormatException {
            return NumberUtils.parseDouble(parameter);
        }

        public double parseDouble(String name, String parameter) throws ServletRequestBindingException {
            return ((Number)this.parse(name, parameter)).doubleValue();
        }

        public double[] parseDoubles(String name, String[] values) throws ServletRequestBindingException {
            this.validateRequiredParameter(name, values);
            double[] parameters = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseDouble(name, values[i]);
            }
            return parameters;
        }
    }

    private static class FloatParser
    extends ParameterParser {
        private FloatParser() {
        }

        @Override
        protected String getType() {
            return "float";
        }

        @Override
        protected Object doParse(String parameter) throws NumberFormatException {
            return Float.valueOf(parameter);
        }

        public float parseFloat(String name, String parameter) throws ServletRequestBindingException {
            return ((Number)this.parse(name, parameter)).floatValue();
        }

        public float[] parseFloats(String name, String[] values) throws ServletRequestBindingException {
            this.validateRequiredParameter(name, values);
            float[] parameters = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseFloat(name, values[i]);
            }
            return parameters;
        }
    }

    private static class LongParser
    extends ParameterParser {
        private LongParser() {
        }

        @Override
        protected String getType() {
            return "long";
        }

        @Override
        protected Object doParse(String parameter) throws NumberFormatException {
            return Long.valueOf(parameter);
        }

        public long parseLong(String name, String parameter) throws ServletRequestBindingException {
            return ((Number)this.parse(name, parameter)).longValue();
        }

        public long[] parseLongs(String name, String[] values) throws ServletRequestBindingException {
            this.validateRequiredParameter(name, values);
            long[] parameters = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseLong(name, values[i]);
            }
            return parameters;
        }
    }

    private static class IntParser
    extends ParameterParser {
        private IntParser() {
        }

        @Override
        protected String getType() {
            return "int";
        }

        @Override
        protected Object doParse(String s) throws NumberFormatException {
            return Integer.valueOf(s);
        }

        public int parseInt(String name, String parameter) throws ServletRequestBindingException {
            return ((Number)this.parse(name, parameter)).intValue();
        }

        public int[] parseInts(String name, String[] values) throws ServletRequestBindingException {
            this.validateRequiredParameter(name, values);
            int[] parameters = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseInt(name, values[i]);
            }
            return parameters;
        }
    }

    private static abstract class ParameterParser {
        private ParameterParser() {
        }

        protected final Object parse(String name, String parameter) throws ServletRequestBindingException {
            this.validateRequiredParameter(name, parameter);
            try {
                return this.doParse(parameter);
            }
            catch (NumberFormatException ex) {
                throw new ServletRequestBindingException("Required " + this.getType() + " parameter '" + name + "' with value of '" + parameter + "' is not a valid number", (Throwable)ex);
            }
        }

        protected final void validateRequiredParameter(String name, Object parameter) throws ServletRequestBindingException {
            if (parameter == null) {
                throw new MissingServletRequestParameterException(name, this.getType());
            }
        }

        protected abstract String getType();

        protected abstract Object doParse(String var1) throws NumberFormatException;
    }
}

