/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core;

import uk.ac.warwick.util.core.StopWatch;

public final class ThreadSafeStopWatch {
    private static ThreadLocal<StopWatch> stopWatch = ThreadSafeStopWatch.createNewStopWatch();

    private ThreadSafeStopWatch() {
    }

    public static void start(String taskName) {
        stopWatch.get().start(taskName);
    }

    public static long stop() {
        return stopWatch.get().stop();
    }

    public static String prettyPrint() {
        return stopWatch.get().prettyPrint();
    }

    public static void setDisplayThresholdInMs(int threshold) {
        stopWatch.get().setDisplayThresholdInMs(threshold);
    }

    public static void destroy() {
        stopWatch.remove();
    }

    private static ThreadLocal<StopWatch> createNewStopWatch() {
        return new ThreadLocal<StopWatch>(){

            @Override
            protected synchronized StopWatch initialValue() {
                return new StopWatch();
            }
        };
    }
}

