/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core;

import java.io.File;
import java.io.IOException;
import uk.ac.warwick.util.core.FileSystemHelper;
import uk.ac.warwick.util.core.spring.FileUtils;

public final class FileSystemHelperImpl
implements FileSystemHelper {
    @Override
    public boolean move(File source, File target) throws IOException {
        if (source.renameTo(target)) {
            return true;
        }
        this.recursiveCopy(source, target);
        FileUtils.recursiveDelete(source);
        return true;
    }

    @Override
    public void recursiveCopy(File source, File target) throws IOException {
        FileUtils.copy(source, target, true);
    }

    @Override
    public void copy(File source, File target) throws IOException {
        FileUtils.copy(source, target, false);
    }

    @Override
    public void optionalCopy(File source, File target) throws IOException {
        if (!source.exists()) {
            return;
        }
        if (!target.exists() && source.isDirectory() && !target.mkdirs()) {
            throw new IllegalStateException("Cannot create target directory: " + target);
        }
        if (source.isFile()) {
            FileUtils.copy(source, target, false);
        }
    }

    @Override
    public void delete(File target) throws IOException {
        FileUtils.recursiveDelete(target);
    }

    @Override
    public void deleteIfEmpty(File target, boolean recurse) throws IOException {
        if (target.isDirectory() && target.list().length == 0) {
            FileUtils.recursiveDelete(target);
            if (recurse) {
                this.deleteIfEmpty(target.getParentFile(), true);
            }
        }
    }

    @Override
    public void deleteIfExists(File target) throws IOException {
        if (target.exists()) {
            this.delete(target);
        }
    }
}

