/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;

public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static <T extends Throwable> T retrieveException(Throwable e, Class<T> clazz) {
        for (Throwable t : ExceptionUtils.retrieveExceptions(e)) {
            if (!t.getClass().equals(clazz)) continue;
            return (T)t;
        }
        return null;
    }

    public static List<Throwable> retrieveExceptions(Throwable e) {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        ExceptionUtils.walkExceptions(exceptions, e);
        return exceptions;
    }

    private static void walkExceptions(List<Throwable> exceptions, Throwable e) {
        if (e == null) {
            return;
        }
        exceptions.add(e);
        ExceptionUtils.walkExceptions(exceptions, e.getCause());
    }

    public static Throwable getInterestingThrowable(Throwable e, Class<? extends Throwable>[] uninterestingExceptions) {
        Throwable nestedE;
        if (ExceptionUtils.isUninteresting(e, uninterestingExceptions) && (nestedE = ExceptionUtils.getCause(e)) != null) {
            return ExceptionUtils.getInterestingThrowable(nestedE, uninterestingExceptions);
        }
        return e;
    }

    private static boolean isUninteresting(Throwable e, Class[] uninterestingExceptions) {
        if (e != null) {
            for (Class clazz : uninterestingExceptions) {
                if (!clazz.isAssignableFrom(e.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    private static Throwable getCause(Throwable e) {
        ServletException nse;
        Throwable result = e.getCause();
        if (e instanceof ServletException && (nse = (ServletException)e).getRootCause() != null) {
            result = nse.getRootCause();
        }
        return result;
    }
}

