/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.convert.cloudconvert;

import com.cloudconvert.client.CloudConvertClient;
import com.cloudconvert.client.setttings.SettingsProvider;
import com.cloudconvert.client.setttings.StringSettingsProvider;
import com.cloudconvert.dto.Status;
import com.cloudconvert.dto.request.ConvertFilesTaskRequest;
import com.cloudconvert.dto.request.UploadImportRequest;
import com.cloudconvert.dto.request.UrlExportRequest;
import com.cloudconvert.dto.response.JobResponse;
import com.cloudconvert.dto.response.TaskResponse;
import com.cloudconvert.dto.response.UserResponse;
import com.cloudconvert.dto.result.Result;
import com.cloudconvert.exception.CloudConvertClientException;
import com.cloudconvert.exception.CloudConvertServerException;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import uk.ac.warwick.util.convert.DocumentConversionResult;
import uk.ac.warwick.util.convert.DocumentConversionService;
import uk.ac.warwick.util.convert.StreamByteSource;
import uk.ac.warwick.util.convert.cloudconvert.CloudConvertDocumentConversionResult;

public class CloudConvertDocumentConversionService
implements DocumentConversionService,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudConvertDocumentConversionService.class);
    private final CloudConvertClient client;

    public CloudConvertDocumentConversionService(String apiKey) {
        this(apiKey, false);
    }

    public CloudConvertDocumentConversionService(String apiKey, boolean sandbox) {
        try {
            this.client = new CloudConvertClient((SettingsProvider)new StringSettingsProvider(apiKey, "", sandbox));
        }
        catch (IOException e) {
            throw new IllegalStateException("Error initialising CloudConvertClient", e);
        }
    }

    @Override
    public CloudConvertDocumentConversionResult convert(ByteSource in, String filename, String inputFormat, String outputFormat) throws IOException {
        String conversionId = UUID.randomUUID().toString();
        try {
            TaskResponse uploadResponse = (TaskResponse)Objects.requireNonNull(((Result)this.client.importUsing().upload(new UploadImportRequest(), in.openStream(), filename)).getBody());
            String convertTaskName = "convert-doc";
            String exportTaskName = "export-doc";
            JobResponse startResult = (JobResponse)Objects.requireNonNull(((Result)this.client.jobs().create((Map)ImmutableMap.of((Object)"convert-doc", (Object)new ConvertFilesTaskRequest().setInput(new String[]{uploadResponse.getId()}).setInputFormat(inputFormat).setOutputFormat(outputFormat), (Object)"export-doc", (Object)new UrlExportRequest().setInput(new String[]{"convert-doc"})))).getBody());
            JobResponse finishResult = (JobResponse)Objects.requireNonNull(((Result)this.client.jobs().wait(startResult.getId())).getBody());
            if (finishResult.getStatus() == Status.ERROR) {
                String message = finishResult.getTasks().stream().map(TaskResponse::getMessage).collect(Collectors.joining(","));
                throw new IOException(String.format("Conversion failed: [%s]", message));
            }
            TaskResponse exportResponse = finishResult.getTasks().stream().filter(t -> t.getName().equals("export-doc")).findFirst().orElseThrow(() -> new NullPointerException("Task export-doc not found"));
            List files = exportResponse.getResult().getFiles();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Converted {} files: {}", (Object)files.size(), (Object)files);
            }
            List<String> urls = files.stream().map(f -> (String)f.get("url")).collect(Collectors.toList());
            return CloudConvertDocumentConversionResult.success(conversionId, urls);
        }
        catch (CloudConvertClientException | CloudConvertServerException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public ByteSource getConvertedFile(DocumentConversionResult result, String url) {
        return StreamByteSource.from(() -> {
            try {
                return (InputStream)((Result)this.client.files().download(url)).getBody();
            }
            catch (CloudConvertClientException | CloudConvertServerException | URISyntaxException e) {
                throw new IOException(e);
            }
        });
    }

    public int getRemainingCredits() throws IOException {
        try {
            return ((UserResponse)((Result)this.client.users().me()).getBody()).getCredits();
        }
        catch (CloudConvertClientException | CloudConvertServerException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public void destroy() throws Exception {
        this.client.close();
    }
}

