/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers.media;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.media.MediaUrlHandler;

public final class PreziMediaUrlHandler
extends MediaUrlHandler {
    private static final Pattern PATTERN = Pattern.compile("https?://(?:.*\\.)?prezi\\.com/([^/]+).*", 2);

    @Override
    public boolean recognises(String url) {
        return PATTERN.matcher(url.toString()).matches();
    }

    @Override
    public String getHtml(String url, Map<String, Object> parameters, MutableContent mc) {
        Matcher m = PATTERN.matcher(url);
        Assert.isTrue((boolean)m.matches());
        String preziId = m.group(1);
        if (!parameters.containsKey("locktopath")) {
            parameters.put("locktopath", "false");
        }
        HashMap model = Maps.newHashMap();
        model.put("id", preziId);
        model.putAll(parameters);
        return this.renderTemplate("media/prezi.ftl", model);
    }
}

