/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import java.util.regex.Pattern;
import uk.ac.warwick.util.content.texttransformers.TextPatternTransformer;

public final class TagTransformer
extends TextPatternTransformer {
    private final Pattern pattern;
    private final TextPatternTransformer.Callback callback;
    private final boolean generatesHead;

    public TagTransformer(String tagName, TextPatternTransformer.Callback callback, boolean generatesHead) {
        this(tagName, "<", ">", callback, generatesHead);
    }

    public TagTransformer(String tagName, String openSymbol, String closeSymbol, TextPatternTransformer.Callback callback, boolean generatesHead) {
        String lt = openSymbol;
        String gt = closeSymbol;
        this.pattern = Pattern.compile(lt + tagName + " ([^" + gt + lt + "]+)" + gt + ".+?" + lt + "/" + tagName + gt, 34);
        this.callback = callback;
        this.generatesHead = generatesHead;
    }

    @Override
    protected Pattern getPattern() {
        return this.pattern;
    }

    @Override
    protected TextPatternTransformer.Callback getCallback() {
        return this.callback;
    }

    @Override
    protected boolean isGeneratesHead() {
        return this.generatesHead;
    }
}

