/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.TextTransformer;

public class NoFollowLinkTransformer
implements TextTransformer {
    private static final Pattern LINK_PATTERN = Pattern.compile("(<a\\s)(.+?>)", 2);
    private static final Pattern REL_PATTERN = Pattern.compile("\\srel=[\"']([^\"']+)[\"']", 2);

    public MutableContent apply(MutableContent mc) {
        String content = mc.getContent();
        Matcher linkMatcher = LINK_PATTERN.matcher(content);
        StringBuffer noFollowed = new StringBuffer();
        while (linkMatcher.find()) {
            linkMatcher.appendReplacement(noFollowed, linkMatcher.group(1) + Matcher.quoteReplacement(this.tidyTail(linkMatcher.group(2))));
        }
        linkMatcher.appendTail(noFollowed);
        mc.setContent(noFollowed.toString());
        return mc;
    }

    private String tidyTail(String linkTail) {
        Matcher relMatcher = REL_PATTERN.matcher(linkTail);
        StringBuilder newLinkTail = new StringBuilder();
        TreeSet rels = Sets.newTreeSet();
        while (relMatcher.find()) {
            rels.add(relMatcher.group(1).toLowerCase());
        }
        rels.add("nofollow");
        newLinkTail.append("rel=\"");
        Iterator iter = rels.iterator();
        while (iter.hasNext()) {
            newLinkTail.append(iter.next());
            if (!iter.hasNext()) continue;
            newLinkTail.append(" ");
        }
        newLinkTail.append("\" ");
        newLinkTail.append(relMatcher.replaceAll(""));
        return newLinkTail.toString();
    }
}

