/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.warwick.util.content.texttransformers.Attribute;

public final class AttributeStringParser {
    private static final Pattern NAME_EQUALS = Pattern.compile("^(\\s*([\\w-]+)=).+", 34);
    private static final Pattern OPENER = Pattern.compile("^\\s*([\"']|\\&#8217\\;|\\&#8221\\;|\\&quot\\;)");
    private static final Pattern UNQUOTED = Pattern.compile("^\\s*[^\\s]+");
    private static final char ESCAPE = '\\';
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    public AttributeStringParser(String attributesString) {
        String text = attributesString.trim();
        Matcher matcher = NAME_EQUALS.matcher(text);
        while (matcher.find()) {
            String value;
            String name = matcher.group(2);
            Matcher openMatcher = OPENER.matcher(text = text.substring(matcher.group(1).length()));
            if (openMatcher.find()) {
                String openedQuote = openMatcher.group(1);
                int end = this.findEndOfValue(openedQuote, text = text.substring(openMatcher.group().length()));
                value = end > -1 ? text.substring(0, end) : text;
                value = value.replace('\\' + openedQuote, openedQuote);
                text = text.substring(end + openedQuote.length());
            } else {
                Matcher unquotedMatcher = UNQUOTED.matcher(text);
                value = "";
                if (unquotedMatcher.find()) {
                    value = unquotedMatcher.group().replaceAll("(&nbsp;)+", "");
                }
                try {
                    text = text.substring(unquotedMatcher.group().length()).trim();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            this.attributes.add(new Attribute(name, value));
            matcher = NAME_EQUALS.matcher(text);
        }
    }

    private int findEndOfValue(String openedQuote, String text) {
        int end;
        int start = 0;
        while ((end = text.indexOf(openedQuote, start)) > -1) {
            start = end + 1;
            if (end > 0 && text.charAt(end - 1) == '\\') continue;
        }
        return end;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public String getValue(String attributeName) {
        for (Attribute a : this.attributes) {
            if (!attributeName.equals(a.getName())) continue;
            return a.getValue();
        }
        return null;
    }
}

