/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.cleaner;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.ccil.cowan.tagsoup.ElementType;
import org.ccil.cowan.tagsoup.Schema;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import uk.ac.warwick.html5.HTML5Schema;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.cleaner.AttributesImpl;
import uk.ac.warwick.util.content.cleaner.BodyContentFilter;
import uk.ac.warwick.util.content.cleaner.DefaultHtmlContentWriter;
import uk.ac.warwick.util.content.cleaner.HtmlCleaner;
import uk.ac.warwick.util.content.cleaner.HtmlContentWriter;
import uk.ac.warwick.util.content.cleaner.TagAndAttributeFilter;
import uk.ac.warwick.util.content.cleaner.TrackingStringBuilder;
import uk.ac.warwick.util.core.StringUtils;

public final class CleanerWriter
implements ContentHandler,
LexicalHandler {
    public static final int INDENT_DEPTH = 2;
    public static final String HEAD_TAG = "head";
    public static final String BODY_TAG = "body";
    public static final String HTML_TAG = "html";
    public static final int MAX_STACK_SIZE = 1000;
    static final Pattern STRIKETHROUGH_CSS = Pattern.compile("^\\s*text-decoration:\\s*line-through;?\\s*$", 2);
    private final Set<String> extraLineBreak = CleanerWriter.toSet("h1", "h2", "h3", "h4", "h5", "h6", "p", "ol", "ul", "script", "table", "hr", "div", "form");
    private final Set<String> preformattedTags = CleanerWriter.toSet("code", "pre", "script", "style");
    private final Map<String, String> tagReplacements;
    private final TagAndAttributeFilter filter;
    private HtmlContentWriter contentWriter;
    private BodyContentFilter contentFilter = BodyContentFilter.DO_NOTHING_CONTENT_FILTER;
    private TrackingStringBuilder buffer;
    private int tagDepth;
    private int preformattedTagDepth;
    private boolean inHead;
    private boolean inScript;
    private boolean elementJustOpened;
    private Stack<StackElement> tagStack;
    private Stack<String> tagNameStack;
    private HtmlCleaner.ContentType lastContentType = HtmlCleaner.ContentType.none;
    private boolean printingContent = true;
    private boolean prettyPrint = false;
    private final MutableContent mc;
    private final Schema schema = new HTML5Schema();

    public CleanerWriter(TagAndAttributeFilter theFilter, MutableContent mc) {
        this.mc = mc;
        this.buffer = new TrackingStringBuilder();
        this.filter = theFilter;
        this.contentWriter = new DefaultHtmlContentWriter(this.filter, this.contentFilter);
        this.tagReplacements = new HashMap<String, String>();
        this.tagReplacements.put("h1", "h2");
    }

    public CleanerWriter(TagAndAttributeFilter theFilter, BodyContentFilter theContentFilter, MutableContent mc) {
        this(theFilter, mc);
        this.contentFilter = theContentFilter;
    }

    @Override
    public void startDocument() throws SAXException {
        this.buffer = new TrackingStringBuilder();
        this.tagDepth = 0;
        this.preformattedTagDepth = 0;
        this.inHead = false;
        this.elementJustOpened = false;
        this.tagStack = new Stack();
        this.tagNameStack = new Stack();
    }

    public String getOutput() {
        return this.buffer.toString();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inHead || !this.isPrintingContent()) {
            return;
        }
        String characters = String.copyValueOf(ch, start, length);
        if (!this.inScript) {
            characters = this.contentWriter.htmlEscapeAll(characters);
            characters = this.contentFilter.handleCharacters(characters);
        }
        if (this.isInPreformattedArea()) {
            this.buffer.append(characters);
            this.lastContentType = HtmlCleaner.ContentType.characters;
        } else if (StringUtils.hasText(characters)) {
            if (this.prettyPrint) {
                characters = StringUtils.compactWhitespace(characters);
            }
            this.buffer.append(characters);
            this.lastContentType = HtmlCleaner.ContentType.characters;
        } else if (!this.buffer.isStartOfLine()) {
            if (this.prettyPrint) {
                this.buffer.append(' ');
            } else {
                this.buffer.append(characters);
            }
            this.lastContentType = HtmlCleaner.ContentType.whitespace;
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.prettyPrint) {
            this.buffer.append(ch, start, length);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String style;
        String mceName;
        String style2;
        String clazz;
        String tagName = localName;
        StackElement inverse = null;
        if (this.handleUnwantedSurroundingsStart(localName, atts)) {
            this.pushTag(new StackElement(tagName, tagName, atts, false, true, inverse));
            return;
        }
        if (localName.equals("script")) {
            this.inScript = true;
        }
        if (this.preformattedTagDepth == 0) {
            tagName = this.handleReplacements(localName);
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.getLocalName(i);
            String value = this.contentFilter.handleAttributeValue(atts.getValue(i), tagName, name);
            attributes.put(name, value);
        }
        AttributesImpl attsImpl = new AttributesImpl(atts, attributes);
        String cssClass = attsImpl.getValue("class");
        if (cssClass != null && cssClass.contains("mce")) {
            cssClass = cssClass.replaceAll("\\S*mce\\S+", "");
            attsImpl.remove("class");
            attsImpl.add("class", cssClass);
        }
        if (localName.equals("span") && (clazz = cssClass) != null && clazz.contains("Apple-style-span") && (style2 = attsImpl.getValue("style")) != null && style2.matches(".*font-weight:\\s*normal.*")) {
            for (int i = this.tagStack.size() - 1; i > 0; --i) {
                StackElement tag = (StackElement)this.tagStack.get(i);
                if (!tag.getTagName().matches("strong|em|u")) continue;
                inverse = tag;
                break;
            }
        }
        if ((mceName = attsImpl.getValue("mce_name")) == null || "".equals(mceName)) {
            mceName = attsImpl.getValue("_mce_name");
        }
        if (mceName == null || "".equals(mceName)) {
            mceName = attsImpl.getValue("data-mce-name");
        }
        if (mceName != null) {
            tagName = mceName;
            attsImpl.clear();
        }
        boolean printTag = true;
        boolean printContent = true;
        if (tagName.equals("span") && (style = attsImpl.getValue("style")) != null && STRIKETHROUGH_CSS.matcher(style).matches()) {
            tagName = "strike";
            attsImpl.clear();
        }
        if (tagName.equals("style") && this.isInside("p")) {
            printContent = false;
            printTag = false;
        }
        this.pushTag(new StackElement(localName, tagName, attsImpl, printTag, printContent, inverse));
        this.beforeElementStart(tagName);
        String renderedTag = inverse == null ? this.contentWriter.renderStartTag(tagName, attsImpl, this.mc) : this.contentWriter.renderEndTag(inverse.getTagName());
        if (printTag) {
            this.buffer.append(this.contentFilter.handleTagString(renderedTag, tagName, attributes));
        }
        if (tagName.equals("br") && !this.isInPreformattedArea() && this.prettyPrint) {
            this.buffer.append("\n");
            this.appendIndentSpaces();
        }
        this.elementJustOpened = true;
        this.lastContentType = HtmlCleaner.ContentType.elementStart;
    }

    private void beforeElementStart(String localName) {
        if (!this.isPrintingContent()) {
            return;
        }
        if (this.isPreformatted(localName)) {
            ++this.preformattedTagDepth;
        }
        if (!this.isInlineTag(localName)) {
            if (this.isPrettyPrint()) {
                if (this.elementJustOpened && !this.isInPreformattedArea()) {
                    this.buffer.append("\n");
                }
                this.appendIndentSpaces();
            }
            if (!this.contentWriter.isSelfCloser(localName)) {
                ++this.tagDepth;
            }
        }
    }

    private boolean isPrintingContent() {
        return this.printingContent;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        StackElement poppedTag;
        String tagName = localName;
        if (this.handleUnwantedSurroundingsEnd(tagName)) {
            this.popTag(tagName);
            return;
        }
        if (localName.equals("script")) {
            this.inScript = false;
        }
        if (this.preformattedTagDepth == 0) {
            tagName = this.handleReplacements(localName);
        }
        if ((poppedTag = this.popTag(tagName)) == null || !poppedTag.isPrint() || this.contentWriter.isSelfCloser(poppedTag.getTagName())) {
            return;
        }
        this.doEndElement(poppedTag);
    }

    private void doEndElement(StackElement tag) {
        String tagName = tag.getTagName();
        if (this.isPreformatted(tagName)) {
            --this.preformattedTagDepth;
        }
        if (this.isInlineTag(tagName)) {
            this.renderClosingTag(tag);
        } else {
            --this.tagDepth;
            if (this.lastContentType == HtmlCleaner.ContentType.elementEnd && this.isPrettyPrint()) {
                this.appendIndentSpaces();
            }
            this.renderClosingTag(tag);
            this.renderLineBreaksAfterTagClose(tagName);
        }
        this.elementJustOpened = false;
        this.lastContentType = HtmlCleaner.ContentType.elementEnd;
    }

    @Override
    public void comment(char[] data, int start, int length) throws SAXException {
        if (!this.isPrintingContent() || start < 0 || length < 0) {
            return;
        }
        String characters = String.copyValueOf(data, start, length);
        this.buffer.append("<!--");
        this.buffer.append(characters);
        this.buffer.append("-->");
        if (this.prettyPrint) {
            this.buffer.append("\n");
        }
    }

    private void appendIndentSpaces() {
        if (this.isInPreformattedArea()) {
            return;
        }
        for (int i = 0; i < this.tagDepth * 2; ++i) {
            this.buffer.append(" ");
        }
    }

    private boolean handleUnwantedSurroundingsStart(String localName, Attributes atts) {
        boolean skipTag = false;
        if (localName.equals(HTML_TAG) || localName.equals(BODY_TAG) || localName.equals(HEAD_TAG) || !this.filter.isTagAllowed(localName, this.tagNameStack, false, atts)) {
            skipTag = true;
        }
        if (localName.equals(HEAD_TAG)) {
            this.inHead = true;
        }
        if (this.inHead) {
            skipTag = true;
        }
        return skipTag;
    }

    private boolean handleUnwantedSurroundingsEnd(String localName) {
        boolean skipTag = false;
        if (localName.equals(HTML_TAG) || localName.equals(BODY_TAG) || localName.equals(HEAD_TAG) || !this.filter.isTagAllowed(localName, this.tagNameStack, true, this.peekTag(localName).getAttributes())) {
            skipTag = true;
        }
        if (localName.equals(HEAD_TAG)) {
            this.inHead = false;
        }
        if (this.inHead) {
            skipTag = true;
        }
        return skipTag;
    }

    private void renderLineBreaksAfterTagClose(String localName) {
        if (!this.isPrettyPrint() || this.isInPreformattedArea()) {
            return;
        }
        if (this.requiresExtraLineBreak(localName)) {
            this.buffer.append("\n\n");
        } else {
            this.buffer.append("\n");
        }
    }

    private void renderClosingTag(StackElement tag) {
        String html = tag.inverse == null ? this.contentWriter.renderEndTag(tag.getTagName()) : this.contentWriter.renderStartTag(tag.inverse.getTagName(), tag.inverse.getAttributes(), this.mc);
        this.buffer.append(html);
    }

    private boolean isInlineTag(String tagName) {
        return this.memberOf(tagName, 16384, false) && !this.memberOf(tagName, 2048, false);
    }

    private boolean memberOf(String tagName, int flag, boolean defaultValue) {
        ElementType type = this.schema.getElementType(tagName);
        if (type == null) {
            return defaultValue;
        }
        return (type.memberOf() & flag) == flag;
    }

    private boolean isInside(String tagName) {
        return this.tagNameStack.contains(tagName);
    }

    private boolean isPreformatted(String tagName) {
        return this.preformattedTags.contains(tagName);
    }

    private boolean isInPreformattedArea() {
        return this.preformattedTagDepth > 0;
    }

    private boolean requiresExtraLineBreak(String tagName) {
        return this.extraLineBreak.contains(tagName);
    }

    private void pushTag(StackElement element) {
        this.tagStack.push(element);
        this.tagNameStack.push(element.getTagName());
        if (!element.isPrintContent()) {
            this.printingContent = false;
        }
    }

    private StackElement popTag(String localName) {
        if (this.tagStack.empty()) {
            return null;
        }
        this.tagNameStack.pop();
        StackElement element = this.tagStack.pop();
        if (!element.isPrintContent()) {
            StackElement e;
            boolean anotherTagStopsPrinting = false;
            Iterator iterator = this.tagStack.iterator();
            while (iterator.hasNext() && (e = (StackElement)iterator.next()).isPrintContent()) {
            }
            this.printingContent = !anotherTagStopsPrinting;
        }
        return element;
    }

    private StackElement peekTag(String localName) {
        if (this.tagStack.empty()) {
            return null;
        }
        return this.tagStack.peek();
    }

    private String handleReplacements(String tagName) {
        if (this.tagReplacements.containsKey(tagName)) {
            return this.tagReplacements.get(tagName);
        }
        return tagName;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public static Set<String> toSet(String ... array) {
        return new TreeSet<String>(Arrays.asList(array));
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String arg0) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public HtmlContentWriter getContentWriter() {
        return this.contentWriter;
    }

    public void setContentWriter(HtmlContentWriter contentWriter) {
        this.contentWriter = contentWriter;
    }

    static class StackElement {
        private final String originalTagName;
        private final String tagName;
        private final Attributes attributes;
        private final boolean print;
        private boolean printContent;
        private StackElement inverse;

        public StackElement(String originalTagName, String tagName, Attributes atts, boolean print, boolean printContent, StackElement tinverse) {
            this.originalTagName = originalTagName;
            this.tagName = tagName;
            this.attributes = atts;
            this.print = print;
            this.printContent = printContent;
            this.inverse = tinverse;
        }

        public final String getOriginalTagName() {
            return this.originalTagName;
        }

        public final String getTagName() {
            return this.tagName;
        }

        public final boolean isPrint() {
            return this.print;
        }

        public final Attributes getAttributes() {
            return this.attributes;
        }

        public final StackElement getInverse() {
            return this.inverse;
        }

        public boolean isPrintContent() {
            return this.printContent;
        }
    }
}

