/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.cleaner;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;

public class AttributesImpl
implements Attributes {
    private List<Attribute> attributes = new ArrayList<Attribute>();

    public AttributesImpl(Attributes attrs) {
        int l = attrs.getLength();
        for (int i = 0; i < l; ++i) {
            String name = attrs.getLocalName(i);
            String value = attrs.getValue(i);
            this.add(name, value);
        }
    }

    public AttributesImpl(Attributes attrs, Map<String, String> map) {
        int l = attrs.getLength();
        for (int i = 0; i < l; ++i) {
            String name = attrs.getLocalName(i);
            String value = map.get(name);
            this.add(name, value);
        }
    }

    public void clear() {
        this.attributes.clear();
    }

    public boolean remove(String name) {
        Iterator<Attribute> it = this.attributes.iterator();
        while (it.hasNext()) {
            Attribute val = it.next();
            if (!val.getLocalName().equals(name)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public void add(String name, String value) {
        this.attributes.add(new Attribute(name, value));
    }

    @Override
    public int getIndex(String qName) {
        throw new UnsupportedOperationException("Don't support qnames");
    }

    @Override
    public int getIndex(String uri, String localName) {
        throw new UnsupportedOperationException("Don't support qnames");
    }

    @Override
    public int getLength() {
        return this.attributes.size();
    }

    @Override
    public String getLocalName(int index) {
        return this.attributes.get(index).getLocalName();
    }

    @Override
    public String getQName(int index) {
        throw new UnsupportedOperationException("Don't support qnames");
    }

    @Override
    public String getType(int index) {
        return "CDATA";
    }

    @Override
    public String getType(String qName) {
        return null;
    }

    @Override
    public String getType(String uri, String localName) {
        return null;
    }

    @Override
    public String getURI(int index) {
        return "";
    }

    @Override
    public String getValue(int index) {
        return this.attributes.get(index).getValue();
    }

    @Override
    public String getValue(String qName) {
        for (Attribute a : this.attributes) {
            if (!qName.equals(a.getLocalName())) continue;
            return a.getValue();
        }
        return null;
    }

    @Override
    public String getValue(String uri, String localName) {
        return null;
    }

    public static class Attribute {
        private final String localName;
        private final String value;

        public Attribute(String name, String val) {
            this.localName = name;
            this.value = val;
        }

        public final String getLocalName() {
            return this.localName;
        }

        public final String getValue() {
            return this.value;
        }
    }
}

