/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.collections;

import com.google.common.base.Function;
import java.io.Serializable;

public final class Pair<L, R>
implements Serializable {
    private static final long serialVersionUID = 3671033033084202618L;
    private final L left;
    private final R right;

    public Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public boolean isEqual(Pair<L, R> other) {
        return (this.left == null && other.getLeft() == null || other.getLeft() != null && other.getLeft().equals(this.left)) && (this.right == null && other.getRight() == null || other.getRight() != null && other.getRight().equals(this.right));
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Pair && this.isEqual((Pair)obj);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "<" + (this.left == null ? "null" : this.left.toString()) + "," + (this.right == null ? "null" : this.right.toString()) + ">";
    }

    public static <L, R> Pair<L, R> of(L left, R right) {
        if (left != null && left instanceof String) {
            left = new String((String)left);
        }
        if (right != null && right instanceof String) {
            right = new String((String)right);
        }
        return new Pair<L, R>(left, right);
    }

    public static <L, R> Function<Pair<? extends L, ? extends R>, L> leftFunction() {
        return new Function<Pair<? extends L, ? extends R>, L>(){

            public L apply(Pair<? extends L, ? extends R> pair) {
                return pair.getLeft();
            }
        };
    }

    public static <L, R> Function<Pair<? extends L, ? extends R>, R> rightFunction() {
        return new Function<Pair<? extends L, ? extends R>, R>(){

            public R apply(Pair<? extends L, ? extends R> pair) {
                return pair.getRight();
            }
        };
    }
}

