/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache.spring;

import java.time.Duration;
import java.util.Properties;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import uk.ac.warwick.util.cache.Cache;
import uk.ac.warwick.util.cache.CacheEntryFactory;
import uk.ac.warwick.util.cache.Caches;

public class CacheBean
extends AbstractFactoryBean<Cache<?, ?>> {
    private String name;
    private CacheEntryFactory<?, ?> entryFactory;
    private Duration timeout;
    private Caches.CacheStrategy strategy = Caches.CacheStrategy.CaffeineIfAvailable;
    private Properties properties;

    public Class<Cache> getObjectType() {
        return Cache.class;
    }

    protected Cache<?, ?> createInstance() throws Exception {
        Caches.Builder builder = Caches.builder(this.name, this.strategy).entryFactory(this.entryFactory);
        if (this.properties != null) {
            builder = builder.properties(this.properties);
        }
        if (this.timeout != null) {
            builder = builder.expireAfterWrite(this.timeout);
        }
        return builder.build();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.name == null) {
            throw new IllegalStateException("Must specify a name for the cache");
        }
        if (this.entryFactory == null) {
            throw new IllegalStateException("Must specify a cache entry factory");
        }
        if (this.timeout == null) {
            throw new IllegalStateException("Must specify an entry timeout");
        }
        super.afterPropertiesSet();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEntryFactory(CacheEntryFactory<?, ?> entryFactory) {
        this.entryFactory = entryFactory;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public void setStrategy(Caches.CacheStrategy strategy) {
        this.strategy = strategy;
    }

    public void setStrategyAsString(String strategyAsString) {
        this.strategy = Caches.CacheStrategy.valueOf(strategyAsString);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

