/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.cache.BasicCache;
import uk.ac.warwick.util.cache.CacheEntry;
import uk.ac.warwick.util.cache.CacheEntryFactoryWithDataInitialisation;
import uk.ac.warwick.util.cache.CacheExpiryStrategy;
import uk.ac.warwick.util.cache.CacheStatistics;
import uk.ac.warwick.util.cache.CacheStore;
import uk.ac.warwick.util.cache.CacheWithDataInitialisation;
import uk.ac.warwick.util.cache.Caches;
import uk.ac.warwick.util.cache.TTLCacheExpiryStrategy;

public final class HashMapCacheStore<K extends Serializable, V extends Serializable>
implements CacheStore<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HashMapCacheStore.class);
    private static final int DEFAULT_CACHE_SIZE = 10000;
    private static ConcurrentMap<String, WeakReference<Map<?, ?>>> maps = new ConcurrentHashMap();
    private final Map<K, CacheEntry<K, V>> map;
    private final String name;

    private HashMapCacheStore(String name, Map<K, CacheEntry<K, V>> map) {
        this.name = name;
        this.map = map;
    }

    @Override
    public CacheEntry<K, V> get(K key) {
        return this.map.get(key);
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAll(List<K> keys) {
        return keys.stream().collect(HashMap::new, (m, k) -> m.put(k, this.map.get(k)), HashMap::putAll);
    }

    @Override
    public void put(CacheEntry<K, V> entry, Duration ttl) {
        this.map.put(entry.getKey(), entry);
    }

    @Override
    public boolean remove(K key) {
        this.map.remove(key);
        return true;
    }

    @Override
    public CacheStatistics getStatistics() {
        return new CacheStatistics(this.map.size());
    }

    @Override
    public void setMaxSize(int max) {
    }

    @Override
    public boolean clear() {
        this.map.clear();
        return true;
    }

    @Override
    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public void shutdown() {
        this.clear();
        maps.remove(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static void clearAll() {
        for (WeakReference ref : maps.values()) {
            Map m = (Map)ref.get();
            if (m == null) continue;
            m.clear();
        }
    }

    public static class Builder<K extends Serializable, V extends Serializable, T>
    implements Caches.Builder<K, V, T> {
        private final String name;
        private CacheEntryFactoryWithDataInitialisation<K, V, T> entryFactory;
        private CacheExpiryStrategy<K, V> expiryStrategy = TTLCacheExpiryStrategy.eternal();
        private long maximumSize = 10000L;
        private boolean asynchronousUpdateEnabled;
        private boolean asynchronousOnly;

        public Builder(String name, CacheEntryFactoryWithDataInitialisation<K, V, T> entryFactory) {
            this.name = name;
            this.entryFactory = entryFactory;
        }

        private Builder(String name, CacheEntryFactoryWithDataInitialisation<K, V, T> entryFactory, CacheExpiryStrategy<K, V> expiryStrategy, long maximumSize, boolean asynchronousUpdateEnabled, boolean asynchronousOnly) {
            this(name, entryFactory);
            this.expiryStrategy = expiryStrategy;
            this.maximumSize = maximumSize;
            this.asynchronousUpdateEnabled = asynchronousUpdateEnabled;
            this.asynchronousOnly = asynchronousOnly;
        }

        @Override
        public <U> Builder<K, V, U> dataInitialisingEntryFactory(CacheEntryFactoryWithDataInitialisation<K, V, U> entryFactory) {
            return new Builder<K, V, U>(this.name, entryFactory, this.expiryStrategy, this.maximumSize, this.asynchronousUpdateEnabled, this.asynchronousOnly);
        }

        @Override
        public Builder<K, V, T> expireAfterWrite(Duration duration) {
            this.expiryStrategy = TTLCacheExpiryStrategy.forTTL(duration);
            return this;
        }

        @Override
        public Caches.Builder<K, V, T> expiryStategy(CacheExpiryStrategy<K, V> expiryStrategy) {
            this.expiryStrategy = expiryStrategy;
            return this;
        }

        @Override
        public Builder<K, V, T> maximumSize(long size) {
            this.maximumSize = size;
            return this;
        }

        @Override
        public Caches.Builder<K, V, T> asynchronous() {
            this.asynchronousUpdateEnabled = true;
            return this;
        }

        @Override
        public Caches.Builder<K, V, T> asynchronousOnly() {
            this.asynchronousUpdateEnabled = true;
            this.asynchronousOnly = true;
            return this;
        }

        @Override
        public Builder<K, V, T> properties(Properties properties) {
            LOGGER.debug("Properties can only be set with Memcached cache stores - ignoring");
            return this;
        }

        @Override
        public HashMapCacheStore<K, V> buildStore() {
            WeakReference ref = (WeakReference)maps.get(this.name);
            Map map = null;
            if (ref != null) {
                map = (Map)ref.get();
            }
            if (map == null) {
                map = Collections.synchronizedMap(new LinkedHashMap<K, CacheEntry<K, V>>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<K, CacheEntry<K, V>> eldest) {
                        return (long)this.size() > maximumSize;
                    }
                });
                maps.put(this.name, new WeakReference(map));
            }
            return new HashMapCacheStore(this.name, map);
        }

        @Override
        public CacheWithDataInitialisation<K, V, T> build() {
            return new BasicCache<K, V, T>(this.buildStore(), this.entryFactory, this.expiryStrategy, this.asynchronousUpdateEnabled, this.asynchronousOnly);
        }
    }
}

