/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.atom.spring;

import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleGenerator;
import java.beans.PropertyEditor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.springframework.beans.BeanWrapperImpl;
import uk.ac.warwick.util.atom.spring.SitebuilderModule;
import uk.ac.warwick.util.core.StringUtils;

public final class SitebuilderModuleGenerator
implements ModuleGenerator {
    private static final Set<Namespace> NAMESPACES;

    public void generate(Module module, Element element) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)module);
        Element root = element;
        while (root.getParent() != null && root.getParent() instanceof Element && !root.getName().equals("entry")) {
            root = (Element)element.getParent();
        }
        root.addNamespaceDeclaration(SitebuilderModule.NAMESPACE);
        for (SitebuilderModule.Property prop : SitebuilderModule.Property.values()) {
            if (prop.isEditSpecific()) continue;
            PropertyEditor editor = prop.newPropertyEditor();
            Object value = wrapper.getPropertyValue(prop.name());
            if (value == null) continue;
            editor.setValue(value);
            String asText = editor.getAsText();
            if (!StringUtils.hasText(asText)) continue;
            element.addContent((Content)this.element(prop.getElement(), asText));
        }
    }

    private Element element(String name, String value) {
        Element element = new Element(name, SitebuilderModule.NAMESPACE);
        element.addContent(value);
        return element;
    }

    public String getNamespaceUri() {
        return "http://go.warwick.ac.uk/elab-schemas/atom";
    }

    public Set<Namespace> getNamespaces() {
        return NAMESPACES;
    }

    static {
        HashSet<Namespace> nss = new HashSet<Namespace>();
        nss.add(SitebuilderModule.NAMESPACE);
        NAMESPACES = Collections.unmodifiableSet(nss);
    }
}

