/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.atom;

import com.google.common.collect.Lists;
import com.rometools.rome.feed.atom.Link;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleParser;
import com.rometools.rome.io.impl.DateParser;
import com.rometools.rome.io.impl.NumberParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jdom2.Attribute;
import org.jdom2.Element;
import uk.ac.warwick.util.atom.AtomModule;
import uk.ac.warwick.util.atom.AtomModuleImpl;

public final class AtomModuleParser
implements ModuleParser {
    public String getNamespaceUri() {
        return "http://www.w3.org/2005/Atom";
    }

    public Module parse(Element element, Locale locale) {
        Element updated;
        Element published;
        AtomModuleImpl module = new AtomModuleImpl();
        boolean elementsFound = false;
        List linkElements = element.getChildren("link", AtomModule.NAMESPACE);
        if (!linkElements.isEmpty()) {
            elementsFound = true;
            ArrayList links = Lists.newArrayList();
            for (Element linkElement : linkElements) {
                links.add(this.parseLink(linkElement));
            }
            module.setLinks(links);
        }
        if ((published = element.getChild("published", AtomModule.NAMESPACE)) != null) {
            elementsFound = true;
            module.setPublishedDate(DateParser.parseDate((String)published.getText(), (Locale)locale));
        }
        if ((updated = element.getChild("updated", AtomModule.NAMESPACE)) != null) {
            elementsFound = true;
            module.setUpdatedDate(DateParser.parseDate((String)updated.getText(), (Locale)locale));
        }
        return elementsFound ? module : null;
    }

    private Link parseLink(Element eLink) {
        Long val;
        Link link = new Link();
        String att = this.getAttributeValue(eLink, "rel");
        if (att != null) {
            link.setRel(att);
        }
        if ((att = this.getAttributeValue(eLink, "type")) != null) {
            link.setType(att);
        }
        if ((att = this.getAttributeValue(eLink, "href")) != null) {
            link.setHref(att);
        }
        if ((att = this.getAttributeValue(eLink, "title")) != null) {
            link.setTitle(att);
        }
        if ((att = this.getAttributeValue(eLink, "hreflang")) != null) {
            link.setHreflang(att);
        }
        if ((att = this.getAttributeValue(eLink, "length")) != null && (val = NumberParser.parseLong((String)att)) != null) {
            link.setLength(val.longValue());
        }
        return link;
    }

    private String getAttributeValue(Element e, String attributeName) {
        Attribute attr = this.getAttribute(e, attributeName);
        return attr != null ? attr.getValue() : null;
    }

    private Attribute getAttribute(Element e, String attributeName) {
        Attribute attribute = e.getAttribute(attributeName);
        if (attribute == null) {
            attribute = e.getAttribute(attributeName, AtomModule.NAMESPACE);
        }
        return attribute;
    }
}

