/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.atom;

import com.google.common.collect.ImmutableSet;
import com.rometools.rome.feed.atom.Link;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleGenerator;
import com.rometools.rome.io.impl.DateParser;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import uk.ac.warwick.util.atom.AtomModule;

public final class AtomModuleGenerator
implements ModuleGenerator {
    private static final Set<Namespace> NAMESPACES = ImmutableSet.of((Object)AtomModule.NAMESPACE);

    public void generate(Module module, Element element) {
        AtomModule atomModule = (AtomModule)module;
        Element root = element;
        while (root.getParent() != null && root.getParent() instanceof Element && !root.getName().equals("entry")) {
            root = (Element)element.getParent();
        }
        root.addNamespaceDeclaration(AtomModule.NAMESPACE);
        if (atomModule.getLinks() != null) {
            for (Link link : atomModule.getLinks()) {
                element.addContent((Content)this.generateLinkElement(link));
            }
        }
        if (atomModule.getPublishedDate() != null) {
            element.addContent((Content)this.element("published", DateParser.formatW3CDateTime((Date)atomModule.getPublishedDate(), (Locale)Locale.getDefault())));
        }
        if (atomModule.getUpdatedDate() != null) {
            element.addContent((Content)this.element("updated", DateParser.formatW3CDateTime((Date)atomModule.getUpdatedDate(), (Locale)Locale.getDefault())));
        }
    }

    private Element generateLinkElement(Link link) {
        Element linkElement = new Element("link", AtomModule.NAMESPACE);
        if (link.getRel() != null) {
            Attribute relAttribute = new Attribute("rel", link.getRel());
            linkElement.setAttribute(relAttribute);
        }
        if (link.getType() != null) {
            Attribute typeAttribute = new Attribute("type", link.getType());
            linkElement.setAttribute(typeAttribute);
        }
        if (link.getHref() != null) {
            Attribute hrefAttribute = new Attribute("href", link.getHref());
            linkElement.setAttribute(hrefAttribute);
        }
        if (link.getHreflang() != null) {
            Attribute hreflangAttribute = new Attribute("hreflang", link.getHreflang());
            linkElement.setAttribute(hreflangAttribute);
        }
        if (link.getTitle() != null) {
            Attribute title = new Attribute("title", link.getTitle());
            linkElement.setAttribute(title);
        }
        if (link.getLength() != 0L) {
            Attribute lenght = new Attribute("length", Long.toString(link.getLength()));
            linkElement.setAttribute(lenght);
        }
        return linkElement;
    }

    private Element element(String name, String value) {
        Element element = new Element(name, AtomModule.NAMESPACE);
        element.addContent(value);
        return element;
    }

    public String getNamespaceUri() {
        return "http://www.w3.org/2005/Atom";
    }

    public Set<Namespace> getNamespaces() {
        return NAMESPACES;
    }
}

