/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ant;

import com.asual.lesscss.LessEngine;
import com.asual.lesscss.LessException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import uk.ac.warwick.util.core.spring.FileUtils;

public class LessCSSTask
extends Task {
    private List<FileSet> fileSets = new ArrayList<FileSet>();
    private File todir;

    public void addFileSet(FileSet s) {
        this.fileSets.add(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.fileSets.isEmpty()) {
            throw new BuildException("At least one fileset must be specified, or use dir attribute");
        }
        if (this.todir == null) {
            throw new BuildException("Must specify todir");
        }
        if (!this.todir.exists() && !this.todir.mkdirs()) {
            throw new BuildException("todir can't be created");
        }
        LessEngine engine = new LessEngine();
        String currentFilename = null;
        try {
            for (FileSet fileSet : this.fileSets) {
                DirectoryScanner ds = fileSet.getDirectoryScanner(this.getProject());
                File baseDir = ds.getBasedir();
                String[] stringArray = ds.getIncludedFiles();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String file;
                    currentFilename = file = stringArray[i];
                    String sourceFile = baseDir + "/" + file;
                    String newFilename = FileUtils.getFileNameWithoutExtension(file) + ".css";
                    File targetFile = new File(this.todir, newFilename);
                    targetFile.getParentFile().mkdirs();
                    String compiled = engine.compile(new File(sourceFile)).replace("\\n", "\n");
                    try (FileWriter f = new FileWriter(targetFile);){
                        f.write(compiled);
                        continue;
                    }
                }
            }
        }
        catch (LessException e) {
            throw new BuildException((Throwable)e, new Location(currentFilename));
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e, new Location(currentFilename));
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, new Location(currentFilename));
        }
    }

    public void setTodir(File todir) {
        this.todir = todir;
    }

    public void setDir(File dir) {
        FileSet fs = new FileSet();
        fs.setDir(dir);
        fs.setIncludes("**/*.less");
        this.fileSets.add(fs);
    }
}

