/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.utils;

public final class StuTalkEncodeUtils {
    public static final String SLASH_CHAR = "/";
    public static final String ENCODED_SLASH = "@@";
    public static final String ALL_MATCHING = "<GOLD>*";
    public static final String NULL_MATCHING = "<GOLD>NULL";
    public static final String OR_MATCHING = "<GOLD>|";
    public static final String NE_MATCHING = "<GOLD>NE";
    public static final String GE_MATCHING = "<GOLD>GE";
    public static final String G_MATCHING = "<GOLD>G";
    public static final String LE_MATCHING = "<GOLD>LE";
    public static final String L_MATCHING = "<GOLD>L";
    private static final String NULL_ERROR_MESSAGE = "Value cannot be null. Please use NULL_MATCHING instead.";

    private StuTalkEncodeUtils() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated directly.");
    }

    public static String startsWith(String value) {
        if (value == null) {
            throw new IllegalArgumentException(NULL_ERROR_MESSAGE);
        }
        return StuTalkEncodeUtils.encode(value).concat(ALL_MATCHING);
    }

    public static String greaterThanOrEqualTo(String value) {
        return StuTalkEncodeUtils.concat(GE_MATCHING, value);
    }

    public static String greaterThan(String value) {
        return StuTalkEncodeUtils.concat(G_MATCHING, value);
    }

    public static String lessThanOrEqualTo(String value) {
        return StuTalkEncodeUtils.concat(LE_MATCHING, value);
    }

    public static String lessThan(String value) {
        return StuTalkEncodeUtils.concat(L_MATCHING, value);
    }

    public static String notEqualTo(String value) {
        return StuTalkEncodeUtils.concat(NE_MATCHING, value);
    }

    public static String isNull() {
        return NULL_MATCHING;
    }

    public static String isAny() {
        return ALL_MATCHING;
    }

    public static String either(String a, String b) {
        return StuTalkEncodeUtils.concat(StuTalkEncodeUtils.concat(a, OR_MATCHING), b);
    }

    public static String encode(String value) {
        if (value == null) {
            throw new IllegalArgumentException(NULL_ERROR_MESSAGE);
        }
        return value.replace(SLASH_CHAR, ENCODED_SLASH);
    }

    public static String decode(String value) {
        if (value == null) {
            return null;
        }
        return value.replace(ENCODED_SLASH, SLASH_CHAR);
    }

    private static String concat(String a, String b) {
        if (a == null || b == null) {
            throw new IllegalArgumentException(NULL_ERROR_MESSAGE);
        }
        return a.concat(b);
    }
}

