/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.httpclient;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import uk.ac.warwick.util.collections.Pair;

public class AisHttpRequest {
    private final String correlationId;
    private final String requestId;
    private final String path;
    private final Object body;
    private final List<Pair<String, String>> queryParams;
    private final List<Pair<String, String>> headers;

    private AisHttpRequest(Builder builder) {
        this.correlationId = builder.correlationId;
        this.requestId = builder.requestId;
        this.path = builder.path;
        this.body = builder.body;
        this.queryParams = builder.queryParams;
        this.headers = builder.headers;
    }

    public AisHttpRequest(String correlationId, String requestId, String path, Object body, List<Pair<String, String>> queryParams, List<Pair<String, String>> headers) {
        this.requestId = requestId == null ? UUID.randomUUID().toString() : requestId;
        this.correlationId = correlationId == null ? this.requestId : correlationId;
        this.path = path;
        this.body = body;
        this.queryParams = queryParams == null ? new ArrayList() : queryParams;
        this.headers = headers == null ? new ArrayList() : headers;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getPath() {
        return this.path;
    }

    public Object getBody() {
        return this.body;
    }

    public List<Pair<String, String>> getQueryParams() {
        return this.queryParams;
    }

    public List<Pair<String, String>> getHeaders() {
        return this.headers;
    }

    public AisHttpRequest addQueryParam(Pair<String, String> queryParam) {
        this.queryParams.add(queryParam);
        return this;
    }

    public AisHttpRequest addHeader(Pair<String, String> header) {
        this.headers.add(header);
        return this;
    }

    public static class Builder {
        private final String requestId;
        private String correlationId;
        private String path;
        private Object body;
        private final List<Pair<String, String>> queryParams;
        private final List<Pair<String, String>> headers;

        public Builder() {
            this.correlationId = this.requestId = UUID.randomUUID().toString();
            this.queryParams = new ArrayList<Pair<String, String>>();
            this.headers = new ArrayList<Pair<String, String>>();
        }

        public Builder correlationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder body(Object body) {
            this.body = body;
            return this;
        }

        public Builder addQueryParam(Pair<String, String> queryParam) {
            this.queryParams.add(queryParam);
            return this;
        }

        public Builder addHeader(Pair<String, String> header) {
            this.headers.add(header);
            return this;
        }

        public AisHttpRequest build() {
            return new AisHttpRequest(this);
        }
    }
}

