/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.helpers;

import uk.ac.warwick.util.ais.auth.Authenticator;
import uk.ac.warwick.util.ais.auth.model.AuthenticationResult;
import uk.ac.warwick.util.ais.auth.model.ClientCredentialsRequest;
import uk.ac.warwick.util.ais.auth.model.ClientCredentialsResult;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpRequest;
import uk.ac.warwick.util.ais.core.httpclient.HttpRequestBuilder;
import uk.ac.warwick.util.collections.Pair;

public class AisHttpRequestAuthorizer<R>
implements HttpRequestBuilder<R> {
    protected static final String SPACE = " ";
    protected final String defaultScope;
    protected final Authenticator<ClientCredentialsRequest, ClientCredentialsResult> authenticator;
    protected final HttpRequestBuilder<R> delegate;

    public AisHttpRequestAuthorizer(String defaultScope, Authenticator<ClientCredentialsRequest, ClientCredentialsResult> authenticator, HttpRequestBuilder<R> delegate) {
        if (defaultScope == null || defaultScope.isEmpty()) {
            throw new IllegalArgumentException("defaultScope cannot be null or empty.");
        }
        if (authenticator == null) {
            throw new IllegalArgumentException("OAuth2ClientCredentialsAuthenticator cannot be null.");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("HttpRequestBuilder cannot be null.");
        }
        this.defaultScope = defaultScope;
        this.authenticator = authenticator;
        this.delegate = delegate;
    }

    @Override
    public R buildHttpRequest(String method, AisHttpRequest request) {
        this.addAuthorizationHeader(request);
        return this.delegate.buildHttpRequest(method, request);
    }

    protected void addAuthorizationHeader(AisHttpRequest request) {
        AuthenticationResult result = this.doAuthentication(this.defaultScope, false);
        String authorization = result.getTokenType() + SPACE + result.getAccessToken();
        request.addHeader((Pair<String, String>)new Pair((Object)"Authorization", (Object)authorization));
    }

    protected AuthenticationResult doAuthentication(String scope, boolean skipCache) {
        ClientCredentialsRequest request = new ClientCredentialsRequest.Builder().addScope(scope).skipCache(skipCache).build();
        return this.authenticator.authenticate(request);
    }
}

