/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.auth.token;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AccessToken {
    private final String tokenType;
    private final String tokenValue;
    private final Long expiresIn;
    private final Instant expiryTime;

    @JsonCreator
    public AccessToken(@JsonProperty(value="access_token") String tokenValue, @JsonProperty(value="token_type") String tokenType, @JsonProperty(value="expires_in") Long expiresIn) {
        this.tokenValue = tokenValue;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
        this.expiryTime = Instant.now().plusSeconds(expiresIn);
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public Instant getExpiryTime() {
        return this.expiryTime;
    }
}

