/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.apim.stutalk;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpRequest;
import uk.ac.warwick.util.ais.core.utils.StuTalkEncodeUtils;
import uk.ac.warwick.util.collections.Pair;

public final class StuTalkHttpRequestBuilder {
    private final String requestId;
    private String correlationId;
    private String apiCode;
    private Object body;
    private final List<Pair<String, String>> pathVariables;
    private final List<Pair<String, String>> queryParams;
    private final List<Pair<String, String>> headers;

    public StuTalkHttpRequestBuilder() {
        this.correlationId = this.requestId = UUID.randomUUID().toString();
        this.pathVariables = new ArrayList<Pair<String, String>>();
        this.queryParams = new ArrayList<Pair<String, String>>();
        this.headers = new ArrayList<Pair<String, String>>();
    }

    public StuTalkHttpRequestBuilder correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public StuTalkHttpRequestBuilder apiCode(String apiCode) {
        this.apiCode = apiCode;
        return this;
    }

    public StuTalkHttpRequestBuilder body(Object body) {
        this.body = body;
        return this;
    }

    public StuTalkHttpRequestBuilder addQueryParam(String key, String value) {
        this.queryParams.add((Pair<String, String>)new Pair((Object)key, (Object)value));
        return this;
    }

    public StuTalkHttpRequestBuilder addPathVariable(String key, String value) {
        this.pathVariables.add((Pair<String, String>)new Pair((Object)key, (Object)value));
        return this;
    }

    public StuTalkHttpRequestBuilder addHeader(Pair<String, String> header) {
        this.headers.add(header);
        return this;
    }

    public AisHttpRequest build() {
        if (this.apiCode == null) {
            throw new IllegalArgumentException("API Code cannot be null.");
        }
        String apiPath = this.buildPath();
        return new AisHttpRequest(this.correlationId, this.requestId, apiPath, this.body, this.queryParams, this.headers);
    }

    private String buildPath() {
        StringBuilder path = new StringBuilder(this.apiCode);
        for (Pair<String, String> pathVariable : this.pathVariables) {
            path.append("/").append((String)pathVariable.getLeft()).append("/").append(StuTalkEncodeUtils.encode((String)pathVariable.getRight()));
        }
        return path.toString();
    }
}

