/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.apim;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import uk.ac.warwick.util.ais.apim.AisHttpOperations;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpAsyncClient;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpRequest;

public abstract class AbstractAisHttpClientTemplate
implements AisHttpOperations {
    protected static final String GET_METHOD = "GET";
    protected static final String POST_METHOD = "POST";
    protected static final String PUT_METHOD = "PUT";
    protected static final String DELETE_METHOD = "DELETE";
    protected final AisHttpAsyncClient httpAsyncClient;
    protected long timeout = 60L;

    protected AbstractAisHttpClientTemplate(AisHttpAsyncClient httpAsyncClient) {
        this.httpAsyncClient = httpAsyncClient;
    }

    @Override
    public <T> CompletableFuture<T> getAsync(AisHttpRequest request, TypeReference<T> typeReference) {
        return this.httpAsyncClient.sendRequestAsync(GET_METHOD, request, typeReference);
    }

    @Override
    public <T> CompletableFuture<T> postAsync(AisHttpRequest request, TypeReference<T> typeReference) {
        return this.httpAsyncClient.sendRequestAsync(POST_METHOD, request, typeReference);
    }

    @Override
    public <T> CompletableFuture<T> putAsync(AisHttpRequest request, TypeReference<T> typeReference) {
        return this.httpAsyncClient.sendRequestAsync(PUT_METHOD, request, typeReference);
    }

    @Override
    public <T> CompletableFuture<T> deleteAsync(AisHttpRequest request, TypeReference<T> typeReference) {
        return this.httpAsyncClient.sendRequestAsync(DELETE_METHOD, request, typeReference);
    }

    @Override
    public <T> T get(AisHttpRequest request, TypeReference<T> typeReference) {
        return this.httpAsyncClient.sendRequest(GET_METHOD, request, typeReference, this.timeout, TimeUnit.SECONDS);
    }

    @Override
    public <T> T post(AisHttpRequest request, TypeReference<T> typeReference) {
        return this.httpAsyncClient.sendRequest(POST_METHOD, request, typeReference, this.timeout, TimeUnit.SECONDS);
    }

    @Override
    public <T> T put(AisHttpRequest request, TypeReference<T> typeReference) {
        return this.httpAsyncClient.sendRequest(PUT_METHOD, request, typeReference, this.timeout, TimeUnit.SECONDS);
    }

    @Override
    public <T> T delete(AisHttpRequest request, TypeReference<T> typeReference) {
        return this.httpAsyncClient.sendRequest(DELETE_METHOD, request, typeReference, this.timeout, TimeUnit.SECONDS);
    }
}

