/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.utils;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.ais.core.utils.StuTalkEncodeUtils;

public class StuTalkEncodeUtilsTest {
    @Test
    public void startsWith_validValue_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.startsWith((String)"5553778");
        Assert.assertEquals((Object)"5553778<GOLD>*", (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void startsWith_nullValue_throwsException() {
        StuTalkEncodeUtils.startsWith(null);
    }

    @Test
    public void greaterThanOrEqualTo_validValue_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.greaterThanOrEqualTo((String)"5553778");
        Assert.assertEquals((Object)"<GOLD>GE5553778", (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void greaterThanOrEqualTo_nullValue_throwsException() {
        StuTalkEncodeUtils.greaterThanOrEqualTo(null);
    }

    @Test
    public void greaterThan_validValue_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.greaterThan((String)"5553778");
        Assert.assertEquals((Object)"<GOLD>G5553778", (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void greaterThan_nullValue_throwsException() {
        StuTalkEncodeUtils.greaterThan(null);
    }

    @Test
    public void lessThanOrEqualTo_validValue_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.lessThanOrEqualTo((String)"5553778");
        Assert.assertEquals((Object)"<GOLD>LE5553778", (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void lessThanOrEqualTo_nullValue_throwsException() {
        StuTalkEncodeUtils.lessThanOrEqualTo(null);
    }

    @Test
    public void lessThan_validValue_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.lessThan((String)"5553778");
        Assert.assertEquals((Object)"<GOLD>L5553778", (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void lessThan_nullValue_throwsException() {
        StuTalkEncodeUtils.lessThan(null);
    }

    @Test
    public void notEqualTo_validValue_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.notEqualTo((String)"5553778");
        Assert.assertEquals((Object)"<GOLD>NE5553778", (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void notEqualTo_nullValue_throwsException() {
        StuTalkEncodeUtils.notEqualTo(null);
    }

    @Test
    public void isNull_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.isNull();
        Assert.assertEquals((Object)"<GOLD>NULL", (Object)result);
    }

    @Test
    public void isAny_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.isAny();
        Assert.assertEquals((Object)"<GOLD>*", (Object)result);
    }

    @Test
    public void either_validValues_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.either((String)"value1", (String)"value2");
        Assert.assertEquals((Object)"value1<GOLD>|value2", (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void either_nullFirstValue_throwsException() {
        StuTalkEncodeUtils.either(null, (String)"value2");
    }

    @Test(expected=IllegalArgumentException.class)
    public void either_nullSecondValue_throwsException() {
        StuTalkEncodeUtils.either((String)"value1", null);
    }

    @Test
    public void encode_validValue_encodesSlashCharacter() {
        String result = StuTalkEncodeUtils.encode((String)"value/with/slash");
        Assert.assertEquals((Object)"value@@with@@slash", (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void encode_nullValue_throwsException() {
        StuTalkEncodeUtils.encode(null);
    }

    @Test
    public void decode_validValue_decodesSlashCharacter() {
        String result = StuTalkEncodeUtils.decode((String)"value@@with@@slash");
        Assert.assertEquals((Object)"value/with/slash", (Object)result);
    }

    @Test
    public void decode_nullValue_returnsNull() {
        Assert.assertNull((Object)StuTalkEncodeUtils.decode(null));
    }
}

