/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.ais.core.json.NewlineDeserializerTransformer;
import uk.ac.warwick.util.ais.core.json.PipelineStringDeserializer;
import uk.ac.warwick.util.ais.core.json.StringTransformer;

public class NormaliseNewLineDeserializerTest {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final NewlineDeserializerTransformer transformer = new NewlineDeserializerTransformer();
    private final PipelineStringDeserializer deserializer = new PipelineStringDeserializer((StringTransformer)this.transformer);

    @Test
    public void deserialize_unixNewLineValue_convertedToWindowsStyle() throws IOException {
        String json = "{\n        \"mapc\": \"CH910-10\",\n        \"mabs\": \"E01\",\n        \"desc\": \"Neque porro quisquam est qui\\\\n dolorem ipsum quia dolor sit amet,\\n consectetur, adipisci velit...\"\n      }";
        JsonNode jsonNode = this.objectMapper.readTree(json);
        JsonParser stringNode = jsonNode.get("desc").traverse();
        stringNode.nextToken();
        Assert.assertEquals((Object)"Neque porro quisquam est qui\r\n dolorem ipsum quia dolor sit amet,\r\n consectetur, adipisci velit...", (Object)this.deserializer.deserialize(stringNode, null));
    }

    @Test
    public void deserialize_windowsStyleNewLineValue_returnSameValue() throws IOException {
        String json = "{\n        \"mapc\": \"CH910-10\",\n        \"mabs\": \"E01\",\n        \"desc\": \"Neque porro quisquam est qui\\\\r\\\\n dolorem ipsum quia dolor sit amet,\\r\\n consectetur, adipisci velit...\"\n      }";
        JsonNode jsonNode = this.objectMapper.readTree(json);
        JsonParser stringNode = jsonNode.get("desc").traverse();
        stringNode.nextToken();
        Assert.assertEquals((Object)"Neque porro quisquam est qui\\r\\n dolorem ipsum quia dolor sit amet,\r\n consectetur, adipisci velit...", (Object)this.deserializer.deserialize(stringNode, null));
    }
}

