/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.ais.core.exception.AisJsonProcessingException;
import uk.ac.warwick.util.ais.core.json.AbstractAisJsonConverter;

public class AbstractAisJsonConverterTest {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final AbstractAisJsonConverter converter = new AbstractAisJsonConverter(this.objectMapper){};

    @Test
    public void fromJsonNode_validJsonNodeAndTypeReference_returnsDeserializedObject() {
        TypeReference<String> typeReference = new TypeReference<String>(){};
        TextNode jsonNode = JsonNodeFactory.instance.textNode("test");
        String result = (String)this.converter.fromJsonNode((JsonNode)jsonNode, (TypeReference)typeReference);
        Assert.assertEquals((Object)"test", (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void fromJsonNode_nullJsonNode_throwsIllegalArgumentException() {
        this.converter.fromJsonNode(null, (TypeReference)new TypeReference<String>(){});
    }

    @Test(expected=AisJsonProcessingException.class)
    public void fromJsonNode_invalidJsonNode_throwsAisJsonProcessingException() {
        ArrayNode jsonNode = JsonNodeFactory.instance.arrayNode();
        this.converter.fromJsonNode((JsonNode)jsonNode, (TypeReference)new TypeReference<String>(){});
    }

    @Test
    public void fromJsonNode_forClass_returnsDeserializedObject() {
        TextNode jsonNode = JsonNodeFactory.instance.textNode("test");
        String result = (String)this.converter.fromJsonNode((JsonNode)jsonNode, String.class);
        Assert.assertEquals((Object)"test", (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void fromJsonNode_forClassWithNullJsonNode_throwsIllegalArgumentException() {
        this.converter.fromJsonNode(null, String.class);
    }

    @Test
    public void fromJsonString_validJsonStringAndTypeReference_returnsDeserializedObject() {
        String jsonString = "{\"key\":\"value\"}";
        TypeReference<Map<String, String>> typeReference = new TypeReference<Map<String, String>>(){};
        Map result = (Map)this.converter.fromJsonString(jsonString, (TypeReference)typeReference);
        Assert.assertEquals((Object)"value", result.get("key"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void fromJsonString_nullJsonString_throwsIllegalArgumentException() {
        this.converter.fromJsonString(null, (TypeReference)new TypeReference<String>(){});
    }

    @Test(expected=AisJsonProcessingException.class)
    public void fromJsonString_invalidJsonString_throwsAisJsonProcessingException() {
        String jsonString = "{\"key\":value\"}";
        this.converter.fromJsonString(jsonString, (TypeReference)new TypeReference<String>(){});
    }

    @Test
    public void toJsonString_validObject_returnsJsonString() {
        HashMap<String, String> object = new HashMap<String, String>();
        object.put("key", "value");
        String result = this.converter.toJsonString(object);
        Assert.assertEquals((Object)"{\"key\":\"value\"}", (Object)result);
    }

    @Test
    public void toJsonString_nullObject_returnsEmptyJsonObject() {
        String result = this.converter.toJsonString(null);
        Assert.assertEquals((Object)"{}", (Object)result);
    }

    @Test
    public void toJsonNode_validJsonString_returnsJsonNode() {
        String jsonString = "{\"key\":\"value\"}";
        JsonNode result = this.converter.toJsonNode(jsonString);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"value", (Object)result.get("key").asText());
    }

    @Test(expected=IllegalArgumentException.class)
    public void toJsonNode_nullJsonString_throwsIllegalArgumentException() {
        this.converter.toJsonNode(null);
    }

    @Test(expected=AisJsonProcessingException.class)
    public void toJsonNode_invalidJsonString_throwsAisJsonProcessingException() {
        String jsonString = "{\"key\":value\"}";
        this.converter.toJsonNode(jsonString);
    }
}

