/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.httpclient;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import uk.ac.warwick.util.ais.core.exception.AisHttpException;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpAsyncClientBase;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpRequest;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpResponseHandler;
import uk.ac.warwick.util.ais.core.httpclient.HttpRequestBuilder;
import uk.ac.warwick.util.ais.core.httpclient.HttpRequestExecutor;

public class AisHttpAsyncClientBaseTest {
    private static final String TEST_METHOD = "GET";
    private final AisHttpRequest request = new AisHttpRequest.Builder().path("path").build();

    @Test
    public void sendRequestAsync_buildRequestFailure_stopExecuteRequest() throws Exception {
        HttpRequestBuilder requestBuilder = (method, req) -> {
            throw new RuntimeException("Unable to build HttpUriRequest");
        };
        AisHttpResponseHandler responseHandler = (AisHttpResponseHandler)Mockito.mock(AisHttpResponseHandler.class);
        AtomicBoolean isExecuted = new AtomicBoolean(false);
        HttpRequestExecutor executor = req -> {
            isExecuted.set(true);
            return CompletableFuture.completedFuture(Mockito.mock(HttpResponse.class));
        };
        AisHttpAsyncClientBase httpAsyncClient = new AisHttpAsyncClientBase(requestBuilder, responseHandler, executor);
        try {
            httpAsyncClient.sendRequestAsync(TEST_METHOD, this.request, (TypeReference)new TypeReference<String>(){}).get();
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof RuntimeException));
            Assert.assertEquals((Object)"Unable to build HttpUriRequest", (Object)ex.getMessage());
            Assert.assertFalse((boolean)isExecuted.get());
        }
    }

    @Test
    public void sendRequestAsync_executeRequestFailure_throwException() {
        HttpRequestBuilder requestBuilder = (method, req) -> (HttpUriRequest)Mockito.mock(HttpUriRequest.class);
        AisHttpResponseHandler responseHandler = (AisHttpResponseHandler)Mockito.mock(AisHttpResponseHandler.class);
        Mockito.when((Object)responseHandler.handleError((Throwable)Mockito.any())).thenReturn((Object)new AisHttpException(AisHttpException.ErrorType.OTHERS, "Execute Request Failed", (Throwable)new RuntimeException("Execute Request Failed")));
        AtomicBoolean isExecuted = new AtomicBoolean(false);
        HttpRequestExecutor executor = req -> {
            isExecuted.set(true);
            CompletableFuture completableFuture = new CompletableFuture();
            completableFuture.completeExceptionally(new RuntimeException("Execute Request Failed"));
            return completableFuture;
        };
        AisHttpAsyncClientBase httpAsyncClient = new AisHttpAsyncClientBase(requestBuilder, responseHandler, executor);
        try {
            httpAsyncClient.sendRequestAsync(TEST_METHOD, this.request, (TypeReference)new TypeReference<String>(){}).get();
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof AisHttpException));
            Assert.assertEquals((Object)"(errorType=OTHERS,message=Execute Request Failed)", (Object)ex.getCause().getMessage());
            Assert.assertTrue((boolean)isExecuted.get());
            ((AisHttpResponseHandler)Mockito.verify((Object)responseHandler)).handleError((Throwable)Mockito.any());
        }
    }

    @Test
    public void sendRequestAsync_executeRequestSuccess_returnResponse() throws Exception {
        HttpRequestBuilder requestBuilder = (method, req) -> (HttpUriRequest)Mockito.mock(HttpUriRequest.class);
        AisHttpResponseHandler responseHandler = (AisHttpResponseHandler)Mockito.mock(AisHttpResponseHandler.class);
        Mockito.when((Object)responseHandler.handleResponse(Mockito.any(HttpResponse.class), (TypeReference)Mockito.any(TypeReference.class))).thenReturn((Object)"Response");
        AtomicBoolean isExecuted = new AtomicBoolean(false);
        HttpRequestExecutor executor = req -> {
            isExecuted.set(true);
            return CompletableFuture.completedFuture(Mockito.mock(HttpResponse.class));
        };
        AisHttpAsyncClientBase httpAsyncClient = new AisHttpAsyncClientBase(requestBuilder, responseHandler, executor);
        String result = (String)httpAsyncClient.sendRequestAsync(TEST_METHOD, this.request, (TypeReference)new TypeReference<String>(){}).get();
        Assert.assertEquals((Object)"Response", (Object)result);
        Assert.assertTrue((boolean)isExecuted.get());
        ((AisHttpResponseHandler)Mockito.verify((Object)responseHandler)).handleResponse(Mockito.any(HttpResponse.class), (TypeReference)Mockito.any(TypeReference.class));
    }

    @Test
    public void sendRequest_timeoutException_throwException() throws Exception {
        HttpRequestBuilder requestBuilder = (method, req) -> (HttpUriRequest)Mockito.mock(HttpUriRequest.class);
        AisHttpResponseHandler responseHandler = (AisHttpResponseHandler)Mockito.mock(AisHttpResponseHandler.class);
        AtomicBoolean isExecuted = new AtomicBoolean(false);
        HttpRequestExecutor executor = req -> {
            isExecuted.set(true);
            return new CompletableFuture();
        };
        AisHttpAsyncClientBase httpAsyncClient = new AisHttpAsyncClientBase(requestBuilder, responseHandler, executor);
        try {
            httpAsyncClient.sendRequest(TEST_METHOD, this.request, (TypeReference)new TypeReference<String>(){}, 1L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof AisHttpException));
            Assert.assertEquals((Object)"(errorType=CONNECTION_ERROR,message=Request was timed out.)", (Object)ex.getMessage());
            Assert.assertTrue((boolean)isExecuted.get());
            Mockito.verifyZeroInteractions((Object[])new Object[]{responseHandler});
        }
    }

    @Test
    public void sendRequest_aisHttpException_throwException() throws Exception {
        HttpRequestBuilder requestBuilder = (method, req) -> (HttpUriRequest)Mockito.mock(HttpUriRequest.class);
        AisHttpResponseHandler responseHandler = (AisHttpResponseHandler)Mockito.mock(AisHttpResponseHandler.class);
        Mockito.when((Object)responseHandler.handleError((Throwable)Mockito.any())).thenReturn((Object)new AisHttpException(AisHttpException.ErrorType.OTHERS, "Execute Request Failed", (Throwable)new RuntimeException("Execute Request Failed")));
        AtomicBoolean isExecuted = new AtomicBoolean(false);
        HttpRequestExecutor executor = req -> {
            isExecuted.set(true);
            CompletableFuture completableFuture = new CompletableFuture();
            completableFuture.completeExceptionally(new RuntimeException("Execute Request Failed"));
            return completableFuture;
        };
        AisHttpAsyncClientBase httpAsyncClient = new AisHttpAsyncClientBase(requestBuilder, responseHandler, executor);
        try {
            httpAsyncClient.sendRequest(TEST_METHOD, this.request, (TypeReference)new TypeReference<String>(){}, 1L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof AisHttpException));
            Assert.assertEquals((Object)"(errorType=OTHERS,message=Execute Request Failed)", (Object)ex.getMessage());
            Assert.assertTrue((boolean)isExecuted.get());
            ((AisHttpResponseHandler)Mockito.verify((Object)responseHandler)).handleError((Throwable)Mockito.any());
        }
    }

    @Test
    public void sendRequest_buildRequestFailure_throwException() throws Exception {
        HttpRequestBuilder requestBuilder = (method, req) -> {
            throw new RuntimeException("Unable to build HttpUriRequest");
        };
        AisHttpResponseHandler responseHandler = (AisHttpResponseHandler)Mockito.mock(AisHttpResponseHandler.class);
        AtomicBoolean isExecuted = new AtomicBoolean(false);
        HttpRequestExecutor executor = req -> {
            isExecuted.set(true);
            return CompletableFuture.completedFuture(Mockito.mock(HttpResponse.class));
        };
        AisHttpAsyncClientBase httpAsyncClient = new AisHttpAsyncClientBase(requestBuilder, responseHandler, executor);
        try {
            httpAsyncClient.sendRequest(TEST_METHOD, this.request, (TypeReference)new TypeReference<String>(){}, 1L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof AisHttpException));
            Assert.assertEquals((Object)"(errorType=OTHERS,message=An error occurred while executing the request.)", (Object)ex.getMessage());
            Assert.assertFalse((boolean)isExecuted.get());
        }
    }
}

