/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.apache;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import uk.ac.warwick.util.ais.core.apache.DefaultHttpRequestExecutor;

public class DefaultHttpRequestExecutorTest {
    @Test
    public void execute_success() {
        CloseableHttpAsyncClient httpAsyncClient = new CloseableHttpAsyncClient(){

            public void close() throws IOException {
            }

            public boolean isRunning() {
                return true;
            }

            public void start() {
            }

            public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
                HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
                callback.completed((Object)response);
                return CompletableFuture.completedFuture(response);
            }
        };
        DefaultHttpRequestExecutor executor = new DefaultHttpRequestExecutor(httpAsyncClient);
        CompletableFuture response = executor.execute(this.buildRequest());
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.isDone());
        Assert.assertNotNull(response.getNow(null));
    }

    @Test
    public void execute_failure() {
        CloseableHttpAsyncClient httpAsyncClient = new CloseableHttpAsyncClient(){

            public void close() throws IOException {
            }

            public boolean isRunning() {
                return true;
            }

            public void start() {
            }

            public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
                callback.failed((Exception)new RuntimeException("Request failed"));
                return new CompletableFuture();
            }
        };
        DefaultHttpRequestExecutor executor = new DefaultHttpRequestExecutor(httpAsyncClient);
        CompletableFuture response = executor.execute(this.buildRequest());
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.isCompletedExceptionally());
        try {
            response.getNow(null);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof RuntimeException));
            Assert.assertEquals((Object)"Request failed", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void execute_cancelled() {
        CloseableHttpAsyncClient httpAsyncClient = new CloseableHttpAsyncClient(){

            public void close() throws IOException {
            }

            public boolean isRunning() {
                return true;
            }

            public void start() {
            }

            public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
                callback.cancelled();
                return new CompletableFuture();
            }
        };
        DefaultHttpRequestExecutor executor = new DefaultHttpRequestExecutor(httpAsyncClient);
        CompletableFuture response = executor.execute(this.buildRequest());
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.isCompletedExceptionally());
        try {
            response.getNow(null);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof RuntimeException));
            Assert.assertEquals((Object)"Request was cancelled.", (Object)e.getCause().getMessage());
        }
    }

    private HttpUriRequest buildRequest() {
        return RequestBuilder.create((String)"GET").setUri("http://test.url/test/api").build();
    }
}

