/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.apache;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import uk.ac.warwick.util.ais.core.apache.DefaultHttpRequestBuilder;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpRequest;
import uk.ac.warwick.util.ais.core.json.AisJsonConverter;
import uk.ac.warwick.util.ais.core.properties.AisApimProperties;
import uk.ac.warwick.util.collections.Pair;

public class DefaultHttpRequestBuilderTest {
    private final AisApimProperties properties = new AisApimProperties(){

        public String getBapiChannelId() {
            return "bapiChannelId";
        }

        public String getBapiAppId() {
            return "bapiAppId";
        }

        public String getBaseUrl() {
            return "https://base.url/";
        }
    };
    private AisJsonConverter jsonConverter;

    @Before
    public void setup() {
        this.jsonConverter = (AisJsonConverter)Mockito.mock(AisJsonConverter.class);
    }

    @Test
    public void buildHttpRequest_getRequest_success() {
        AisHttpRequest request = new AisHttpRequest("correlationId", "requestId", "/test/api/key1/value1<GOLD>*/key2/value2", null, (List)Lists.newArrayList((Object[])new Pair[]{new Pair((Object)"param-1", (Object)"query-1"), new Pair((Object)"param-2", (Object)"query-2")}), (List)Lists.newArrayList((Object[])new Pair[]{new Pair((Object)"header-1", (Object)"value1"), new Pair((Object)"header-2", (Object)"value2")}));
        DefaultHttpRequestBuilder builder = new DefaultHttpRequestBuilder(this.jsonConverter, this.properties);
        HttpUriRequest result = builder.buildHttpRequest("GET", request);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"GET", (Object)result.getMethod());
        Assert.assertEquals((Object)"https://base.url/test/api/key1/value1%3CGOLD%3E*/key2/value2?param-1=query-1&param-2=query-2", (Object)result.getURI().toString());
        Assert.assertEquals((Object)"header-1", (Object)result.getFirstHeader("header-1").getName());
        Assert.assertEquals((Object)"value1", (Object)result.getFirstHeader("header-1").getValue());
        Assert.assertEquals((Object)"header-2", (Object)result.getFirstHeader("header-2").getName());
        Assert.assertEquals((Object)"value2", (Object)result.getFirstHeader("header-2").getValue());
        Assert.assertEquals((Object)"bapiChannelId", (Object)result.getFirstHeader("bapi-channel-id").getValue());
        Assert.assertEquals((Object)"bapiAppId", (Object)result.getFirstHeader("bapi-app-id").getValue());
        Assert.assertEquals((Object)"correlationId", (Object)result.getFirstHeader("bapi-correlation-id").getValue());
        Assert.assertEquals((Object)"requestId", (Object)result.getFirstHeader("bapi-request-id").getValue());
    }

    @Test
    public void buildHttpRequest_postRequest_success() {
        AisHttpRequest request = new AisHttpRequest(null, null, "/test/api", (Object)"body", null, null);
        DefaultHttpRequestBuilder builder = new DefaultHttpRequestBuilder(this.jsonConverter, this.properties);
        Mockito.when((Object)this.jsonConverter.toJsonString((Object)"body")).thenReturn((Object)"body");
        HttpUriRequest result = builder.buildHttpRequest("POST", request);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"POST", (Object)result.getMethod());
        Assert.assertEquals((Object)"https://base.url/test/api", (Object)result.getURI().toString());
        Assert.assertEquals((Object)"bapiChannelId", (Object)result.getFirstHeader("bapi-channel-id").getValue());
        Assert.assertEquals((Object)"bapiAppId", (Object)result.getFirstHeader("bapi-app-id").getValue());
        Assert.assertNotNull((Object)result.getFirstHeader("bapi-correlation-id").getValue());
        Assert.assertNotNull((String)"requestId", (Object)result.getFirstHeader("bapi-request-id").getValue());
    }

    @Test
    public void buildHttpRequest_withBasePath_success() {
        AisHttpRequest request = new AisHttpRequest.Builder().path("/test/api/key1/value1<GOLD>|value2").correlationId("correlationId").addQueryParam(new Pair((Object)"param-1", (Object)"pValue-1")).build();
        DefaultHttpRequestBuilder builder = new DefaultHttpRequestBuilder(this.jsonConverter, new AisApimProperties(){

            public String getBapiChannelId() {
                return "bapiChannelId";
            }

            public String getBapiAppId() {
                return "bapiAppId";
            }

            public String getBaseUrl() {
                return "https://base.url/basepath/";
            }
        });
        HttpUriRequest result = builder.buildHttpRequest("GET", request);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"GET", (Object)result.getMethod());
        Assert.assertEquals((Object)"https://base.url/basepath/test/api/key1/value1%3CGOLD%3E%7Cvalue2?param-1=pValue-1", (Object)result.getURI().toString());
        Assert.assertEquals((Object)"bapiChannelId", (Object)result.getFirstHeader("bapi-channel-id").getValue());
        Assert.assertEquals((Object)"bapiAppId", (Object)result.getFirstHeader("bapi-app-id").getValue());
        Assert.assertEquals((Object)"correlationId", (Object)result.getFirstHeader("bapi-correlation-id").getValue());
    }
}

