/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.auth;

import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.ais.auth.OAuth2ClientCredentialsAuthenticator;
import uk.ac.warwick.util.ais.auth.credentials.OAuth2ClientCredentials;
import uk.ac.warwick.util.ais.auth.exception.AuthenticationException;
import uk.ac.warwick.util.ais.auth.exception.TokenFetchException;
import uk.ac.warwick.util.ais.auth.model.ClientCredentialsRequest;
import uk.ac.warwick.util.ais.auth.model.ClientCredentialsResult;
import uk.ac.warwick.util.ais.auth.model.OAuth2TokenFetchParameters;
import uk.ac.warwick.util.ais.auth.token.AccessToken;
import uk.ac.warwick.util.ais.auth.token.TokenCache;

public class OAuth2ClientCredentialsAuthenticatorTest {
    private final OAuth2ClientCredentials credentials = new OAuth2ClientCredentials("test_url", "clientId", "clientSecret");
    private final AccessToken newToken = new AccessToken("new_token", "Bearer", Long.valueOf(3600L));
    private final Function<OAuth2TokenFetchParameters, AccessToken> tokenFetcher = oAuth2TokenFetchParameters -> this.newToken;

    @Test
    public void authenticate_validRequestWithCache_returnsCachedToken() throws AuthenticationException {
        TokenCache tokenCache = new TokenCache();
        OAuth2ClientCredentialsAuthenticator authenticator = new OAuth2ClientCredentialsAuthenticator(this.credentials, this.tokenFetcher, tokenCache);
        AccessToken cachedToken = new AccessToken("cached_token", "Bearer", Long.valueOf(1800L));
        tokenCache.getAccessToken("clientId#scope", () -> cachedToken);
        ClientCredentialsRequest request = new ClientCredentialsRequest("scope", Boolean.valueOf(false));
        ClientCredentialsResult result = authenticator.authenticate(request);
        Assert.assertEquals((Object)"scope", (Object)result.getScope());
        Assert.assertEquals((Object)"cached_token", (Object)result.getAccessToken());
        Assert.assertEquals((Object)"Bearer", (Object)result.getTokenType());
        Assert.assertFalse((boolean)result.isExpired());
        Assert.assertFalse((boolean)result.isExpiringAfter(1799));
        Assert.assertTrue((boolean)result.isExpiringAfter(1801));
    }

    @Test
    public void authenticate_validRequestWithoutCache_fetchesNewToken() throws AuthenticationException {
        TokenCache tokenCache = new TokenCache();
        OAuth2ClientCredentialsAuthenticator authenticator = new OAuth2ClientCredentialsAuthenticator(this.credentials, this.tokenFetcher, tokenCache);
        ClientCredentialsRequest request = new ClientCredentialsRequest("scope", Boolean.valueOf(false));
        ClientCredentialsResult result = authenticator.authenticate(request);
        Assert.assertEquals((Object)"scope", (Object)result.getScope());
        Assert.assertEquals((Object)"new_token", (Object)result.getAccessToken());
        Assert.assertEquals((Object)"Bearer", (Object)result.getTokenType());
        Assert.assertFalse((boolean)result.isExpired());
        Assert.assertFalse((boolean)result.isExpiringAfter(3599));
        Assert.assertTrue((boolean)result.isExpiringAfter(3601));
    }

    @Test(expected=AuthenticationException.class)
    public void authenticate_tokenFetcherThrowsException_throwsAuthenticationException() throws AuthenticationException {
        TokenCache tokenCache = new TokenCache();
        Function<OAuth2TokenFetchParameters, AccessToken> failureFetcher = parameters -> {
            throw new TokenFetchException("Failed to fetch token", Integer.valueOf(500), null);
        };
        OAuth2ClientCredentialsAuthenticator authenticator = new OAuth2ClientCredentialsAuthenticator(this.credentials, failureFetcher, tokenCache);
        ClientCredentialsRequest request = new ClientCredentialsRequest("scope", Boolean.valueOf(false));
        authenticator.authenticate(request);
    }

    @Test
    public void authenticate_skipCache_fetchesNewToken() throws AuthenticationException {
        TokenCache tokenCache = new TokenCache();
        OAuth2ClientCredentialsAuthenticator authenticator = new OAuth2ClientCredentialsAuthenticator(this.credentials, this.tokenFetcher, tokenCache);
        AccessToken cachedToken = new AccessToken("cached_token", "Bearer", Long.valueOf(1800L));
        tokenCache.getAccessToken("clientId#scope", () -> cachedToken);
        ClientCredentialsRequest request = new ClientCredentialsRequest("scope", Boolean.valueOf(true));
        ClientCredentialsResult result = authenticator.authenticate(request);
        Assert.assertEquals((Object)"scope", (Object)result.getScope());
        Assert.assertEquals((Object)"new_token", (Object)result.getAccessToken());
        Assert.assertEquals((Object)"Bearer", (Object)result.getTokenType());
        Assert.assertFalse((boolean)result.isExpired());
        Assert.assertFalse((boolean)result.isExpiringAfter(3599));
        Assert.assertTrue((boolean)result.isExpiringAfter(3601));
    }
}

