/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.auth;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.ais.auth.Authenticator;
import uk.ac.warwick.util.ais.auth.AuthenticatorRegistry;

public class AuthenticatorRegistryTest {
    @Test
    public void register_validServiceId_storesAuthenticator() {
        AuthenticatorRegistry registry = new AuthenticatorRegistry();
        Authenticator authenticator = request -> null;
        registry.register("service1", authenticator);
        Assert.assertEquals((Object)authenticator, (Object)registry.getAuthenticator("service1"));
    }

    @Test
    public void getAuthenticator_nonExistentServiceId_returnsNull() {
        AuthenticatorRegistry registry = new AuthenticatorRegistry();
        Assert.assertNull((Object)registry.getAuthenticator("nonExistentService"));
    }

    @Test
    public void register_multipleServiceIds_storesAuthenticators() {
        AuthenticatorRegistry registry = new AuthenticatorRegistry();
        Authenticator authenticator1 = request -> null;
        Authenticator authenticator2 = request -> null;
        registry.register("service1", authenticator1);
        registry.register("service2", authenticator2);
        Assert.assertEquals((Object)authenticator1, (Object)registry.getAuthenticator("service1"));
        Assert.assertEquals((Object)authenticator2, (Object)registry.getAuthenticator("service2"));
    }

    @Test
    public void register_sameServiceId_overwritesAuthenticator() {
        AuthenticatorRegistry registry = new AuthenticatorRegistry();
        Authenticator authenticator1 = request -> null;
        Authenticator authenticator2 = request -> null;
        registry.register("service1", authenticator1);
        registry.register("service1", authenticator2);
        Assert.assertEquals((Object)authenticator2, (Object)registry.getAuthenticator("service1"));
    }
}

